% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secsse_prep.R
\name{create_lambda_list}
\alias{create_lambda_list}
\title{Helper function to automatically create lambda matrices, based on input}
\usage{
create_lambda_list(
  state_names = c(0, 1),
  num_concealed_states = 2,
  transition_matrix,
  model = "ETD",
  concealed_spec_rates = NULL
)
}
\arguments{
\item{state_names}{vector of names of all observed states.}

\item{num_concealed_states}{number of concealed states, generally equivalent
to the number of examined states in the dataset.}

\item{transition_matrix}{a matrix containing a description of all speciation
events, where the first column indicates the source state, the second and
third column indicate the two daughter states, and the fourth column gives
the rate indicator used. E.g.: \verb{["SA", "S", "A", 1]} for a trait state
\code{"SA"} which upon speciation generates two daughter species with traits
\code{"S"} and \code{"A"}, where the number 1 is used as indicator for optimization
of the likelihood.}

\item{model}{used model, choice of \code{"ETD"} (Examined Traits Diversification),
\code{"CTD"} (Concealed Traits Diversification) or \code{"CR"} (Constant Rate).}

\item{concealed_spec_rates}{vector specifying the rate indicators for each
concealed state, length should be identical to \code{num_concealed_states}. If
left empty when using the CTD model, it is assumed that all available
speciation rates are distributed uniformly over the concealed states.}
}
\description{
Helper function to automatically create lambda matrices, based on input
}
\examples{
trans_matrix <- c(0, 0, 0, 1)
trans_matrix <- rbind(trans_matrix, c(1, 1, 1, 2))
lambda_list <- create_lambda_list(state_names = c(0, 1),
                                  num_concealed_states = 2,
                                  transition_matrix = trans_matrix,
                                  model = "ETD")

}
