% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_hidden_items.R
\name{return_hidden_items}
\alias{return_hidden_items}
\title{Returns hidden items (variables) from \code{secuTrialdata} objects}
\usage{
return_hidden_items(x)
}
\arguments{
\item{x}{a \code{secuTrialdata} object}
}
\value{
a data.frame (columns: name, itemtype, label) that pinpoints which items are hidden
}
\description{
Sometimes, during a study, certain fields may be hidden because data should
             no longer be entered into them. If this is the case and the data of these
             fields is part of your export is likely good to know about it.
}
\examples{
# export location
expot_loc <- system.file("extdata", "sT_exports", "lnames",
                         "s_export_CSV-xls_CTU05_long_ref_miss_en_utf8.zip",
                         package = "secuTrialR")
# read export
sT_export <- read_secuTrial(expot_loc)

# return scores
return_hidden_items(sT_export)

}
