% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_plot.R, R/plot.bayesfactor_models.R,
%   R/plot.bayesfactor_parameters.R, R/plot.check_distribution.R,
%   R/plot.check_normality.R, R/plot.check_outliers.R,
%   R/plot.cluster_analysis.R, R/plot.compare_performance.R,
%   R/plot.describe_distribution.R, R/plot.easycormatrix.R,
%   R/plot.easycorrelation.R, R/plot.effectsize_table.R,
%   R/plot.equivalence_test.R, R/plot.estimate_density.R, R/plot.hdi.R,
%   R/plot.n_factors.R, R/plot.p_direction.R, R/plot.p_significance.R,
%   R/plot.parameters_model.R, R/plot.parameters_pca.R, R/plot.parameters_sem.R,
%   R/plot.parameters_simulate.R, R/plot.point_estimates.R, R/plot.rope.R,
%   R/plot.si.R
\name{data_plot}
\alias{data_plot}
\alias{plot.see_bayesfactor_models}
\alias{plot.see_bayesfactor_parameters}
\alias{plot.see_check_distribution}
\alias{plot.see_check_normality}
\alias{plot.see_check_outliers}
\alias{plot.see_cluster_analysis}
\alias{plot.see_compare_performance}
\alias{plot.see_parameters_distribution}
\alias{plot.see_easycormatrix}
\alias{plot.see_easycorrelation}
\alias{plot.see_effectsize_table}
\alias{plot.see_equivalence_test_effectsize}
\alias{plot.see_equivalence_test}
\alias{plot.see_estimate_density}
\alias{plot.see_hdi}
\alias{plot.see_n_factors}
\alias{plot.see_p_direction}
\alias{plot.see_p_significance}
\alias{plot.see_parameters_model}
\alias{plot.see_parameters_pca}
\alias{plot.see_parameters_sem}
\alias{plot.see_parameters_simulate}
\alias{plot.see_point_estimate}
\alias{plot.see_rope}
\alias{plot.see_si}
\title{Prepare objects for plotting or plot objects}
\usage{
data_plot(x, data = NULL, ...)

\method{plot}{see_bayesfactor_models}(
  x,
  n_pies = c("one", "many"),
  value = c("none", "BF", "probability"),
  sort = FALSE,
  log = FALSE,
  prior_odds = NULL,
  ...
)

\method{plot}{see_bayesfactor_parameters}(
  x,
  point_size = 2,
  rope_color = "#0171D3",
  rope_alpha = 0.2,
  show_intercept = FALSE,
  ...
)

\method{plot}{see_check_distribution}(x, point_size = 2, panel = TRUE, ...)

\method{plot}{see_check_normality}(
  x,
  type = c("density", "qq", "pp"),
  data = NULL,
  size = 0.8,
  point_size = 2,
  ...
)

\method{plot}{see_check_outliers}(x, text_size = 3.5, ...)

\method{plot}{see_cluster_analysis}(x, data = NULL, n_columns = NULL, size = 0.6, ...)

\method{plot}{see_compare_performance}(x, size = 1, ...)

\method{plot}{see_parameters_distribution}(
  x,
  dispersion = FALSE,
  dispersion_alpha = 0.3,
  dispersion_color = "#3498db",
  dispersion_style = c("ribbon", "curve"),
  size = 0.7,
  highlight = NULL,
  highlight_color = NULL,
  ...
)

\method{plot}{see_easycormatrix}(
  x,
  show_values = FALSE,
  show_p = FALSE,
  show_legend = TRUE,
  text_size = 3.5,
  digits = 3,
  ...
)

\method{plot}{see_easycorrelation}(x, size = 22, text_color = "white", node_color = "#647687", ...)

\method{plot}{see_effectsize_table}(x, ...)

\method{plot}{see_equivalence_test_effectsize}(x, ...)

\method{plot}{see_equivalence_test}(
  x,
  rope_color = "#0171D3",
  rope_alpha = 0.2,
  show_intercept = FALSE,
  n_columns = 1,
  ...
)

\method{plot}{see_estimate_density}(
  x,
  stack = TRUE,
  show_intercept = FALSE,
  n_columns = 1,
  priors = FALSE,
  priors_alpha = 0.4,
  size = 0.9,
  ...
)

\method{plot}{see_hdi}(
  x,
  data = NULL,
  show_intercept = FALSE,
  show_zero = TRUE,
  show_title = TRUE,
  n_columns = 1,
  ...
)

\method{plot}{see_n_factors}(x, data = NULL, type = c("bar", "line", "area"), size = 1, ...)

\method{plot}{see_p_direction}(
  x,
  data = NULL,
  show_intercept = FALSE,
  priors = FALSE,
  priors_alpha = 0.4,
  n_columns = 1,
  ...
)

\method{plot}{see_p_significance}(
  x,
  data = NULL,
  show_intercept = FALSE,
  priors = FALSE,
  priors_alpha = 0.4,
  n_columns = 1,
  ...
)

\method{plot}{see_parameters_model}(
  x,
  show_intercept = FALSE,
  point_size = 0.8,
  sort = NULL,
  n_columns = NULL,
  ...
)

\method{plot}{see_parameters_pca}(
  x,
  type = c("bar", "line"),
  text_size = 3.5,
  text_color = "black",
  size = 1,
  ...
)

\method{plot}{see_parameters_sem}(
  x,
  data = NULL,
  type = c("regression", "correlation", "loading"),
  threshold_coefficient = NULL,
  threshold_p = NULL,
  ci = TRUE,
  size = 22,
  ...
)

\method{plot}{see_parameters_simulate}(
  x,
  data = NULL,
  stack = TRUE,
  show_intercept = FALSE,
  n_columns = NULL,
  ...
)

\method{plot}{see_point_estimate}(
  x,
  data = NULL,
  point_size = 2,
  text_size = 3.5,
  panel = TRUE,
  show_labels = TRUE,
  show_intercept = FALSE,
  priors = FALSE,
  priors_alpha = 0.4,
  ...
)

\method{plot}{see_rope}(
  x,
  data = NULL,
  rope_alpha = 0.5,
  rope_color = "cadetblue",
  show_intercept = FALSE,
  n_columns = 1,
  ...
)

\method{plot}{see_si}(
  x,
  si_color = "#0171D3",
  si_alpha = 0.2,
  show_intercept = FALSE,
  support_only = FALSE,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a
statistical model or such.}

\item{...}{Arguments passed to or from other methods.}

\item{n_pies}{Number of pies.}

\item{value}{What value to display.}

\item{sort}{\describe{
  \item{Plotting model parameters}{
  If \code{NULL}, coefficients are plotted in the order as they appear in the summary. Use \code{sort = "ascending"} (or \code{sort = TRUE})) resp. \code{sort = "descending"} to sort coefficients in ascending or descending order.
  }
  \item{Plotting Bayes factors}{
  Sort pie-slices by posterior probability (descending)?
  }
}}

\item{log}{Show log-transformed Bayes factors.}

\item{prior_odds}{optional vector of prior odds for the models. See
\code{BayesFactor::priorOdds}. As the size of the pizza slices corresponds
to posterior probability (which is a function of prior probability and the BF),
custom \code{prior_odds} will change the slices' size.}

\item{point_size}{Size of point-geoms.}

\item{rope_color, si_color}{Color of ROPE/SI ribbon.}

\item{rope_alpha, si_alpha}{Transparency level of ROPE/SI ribbon.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the intercept-parameter
has a posterior distribution on a very different location, so density curves of
posterior distributions for other parameters are hardly visible.}

\item{panel}{Logical, if \code{TRUE}, plots are arranged as panels; else,
single plots are returned.}

\item{type}{Character vector, indicating the type of plot (for
\code{\link[performance]{check_normality}}, \code{parameters::model_parameters.lavaan}
or \code{\link[parameters]{n_factors}}).}

\item{size}{Size of geoms. Depends on the context of the \code{plot()} function,
so this argument may change size of points, lines or bars.}

\item{text_size}{Size of text labels.}

\item{n_columns}{For models with multiple components (like fixed and random, count and zero-inflated), defines the number of columns for the panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{dispersion}{Logical, if \code{TRUE}, will add range of dispersion for each variable to the plot.}

\item{dispersion_alpha}{Transparency level of dispersion ribbon.}

\item{dispersion_color}{Color of dispersion ribbon.}

\item{dispersion_style}{Character, style of dispersion area. \code{"ribbon"} for a ribbon, \code{"curve"} for a normal-curve.}

\item{highlight}{Vector with names of categories in \code{x} that should be highlighted.}

\item{highlight_color}{Vector of color values for highlighted categories. The remaining (non-highlighted) categories will be filled with a lighter grey.}

\item{show_values}{Logical, if \code{TRUE}, values are displayed.}

\item{show_p}{Logical, if \code{TRUE}, p-values or significant level is displayed.}

\item{show_legend}{Logical, show or hide legend.}

\item{digits}{Number of decimals used for values.}

\item{text_color}{Color of text labels.}

\item{node_color}{Color of node- or circle-geoms.}

\item{stack}{Logical, if \code{TRUE}, densities are plotted as stacked lines.
Else, densities are plotted for each parameter among each other.}

\item{priors}{Logical, if \code{TRUE}, prior distributions are simulated
(using \code{\link[bayestestR]{simulate_prior}}) and added to the plot.}

\item{priors_alpha}{Alpha value of the prior distributions.}

\item{show_zero}{Logical, if \code{TRUE}, will add a vertical (dotted) line at 0.}

\item{show_title}{Logical, if \code{TRUE}, will show the title of the plot.}

\item{threshold_coefficient}{Numeric, threshold at which value coefficients will be displayed.}

\item{threshold_p}{Numeric, threshold at which value p-values will be displayed.}

\item{ci}{Logical, whether confidence intervals should be added to the plot.}

\item{show_labels}{Logical, if \code{TRUE}, the text labels for the point
estimates (i.e. \emph{"Mean"}, \emph{"Median"} and/or \emph{"MAP"}) are shown.
You may set \code{show_labels = FALSE} in case of overlapping labels, and
add your own legend or footnote to the plot.}

\item{support_only}{Plot only the support data, or show the "raw" prior and posterior distributions? Only applies when plotting \code{\link[bayestestR]{si}}.}
}
\description{
\code{data_plot()} attempts to extract and tranform an object
to be further plotted, while \code{plot()} tries to visualize results of
functions from different packages of the \href{https://github.com/easystats}{easystats-project}.
}
\details{
\code{data_plot()} is in most situation not needed when the purpose
is plotting, since most \code{plot()}-functions in \pkg{see} internally call
\code{data_plot()} to prepare the data for plotting.
\cr \cr
Many \code{plot()}-functions have a \code{data}-argument that is needed when
the data or model for plotting can't be retrieved via \code{data_plot()}. In
such cases, \code{plot()} gives an error and asks for providing data or models.
\cr \cr
Most \code{plot()}-functions work out-of-the-box, i.e. you don't need to do
much more than calling \code{plot(<object>)} (see 'Examples'). Some plot-functions
allow to specify arguments to modify the transparency or color of geoms, these
are shown in the 'Usage' section.
}
\examples{
\dontrun{
library(bayestestR)
if (require("rstanarm")) {
  model <- stan_glm(
    Sepal.Length ~ Petal.Width * Species,
    data = iris,
    chains = 2, iter = 200
  )

  x <- rope(model)
  plot(x)

  x <- hdi(model)
  plot(x) + theme_modern()

  data <- rnorm(1000, 1)
  x <- p_direction(data)
  plot(x)

  x <- p_direction(model)
  plot(x)

  model <- stan_glm(
    mpg ~ wt + gear + cyl + disp,
    chains = 2,
    iter = 200,
    data = mtcars
  )
  x <- equivalence_test(model)
  plot(x)
}
}

library(bayestestR)
library(see)

lm0 <- lm(qsec ~ 1, data = mtcars)
lm1 <- lm(qsec ~ drat, data = mtcars)
lm2 <- lm(qsec ~ wt, data = mtcars)
lm3 <- lm(qsec ~ drat + wt, data = mtcars)

result <- bayesfactor_models(lm1, lm2, lm3, denominator = lm0)

plot(result, n_pies = "one", value = "probability") + theme_modern() +
  scale_fill_pizza(reverse = TRUE)
}
\seealso{
\href{https://easystats.github.io/see/articles/}{Package-Vignettes}
}
