% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedyApproach.R
\name{DEN}
\alias{DEN}
\title{Greedy method for estimating a sparse solution}
\usage{
DEN(
  odeModel,
  alphaStep,
  Beta,
  alpha1,
  alpha2,
  x0,
  optW,
  measFunc,
  measData,
  sd,
  epsilon,
  parameters,
  systemInput,
  modelFunc,
  greedyLogical,
  plotEstimates,
  conjGrad,
  cString,
  nnStates,
  verbose
)
}
\arguments{
\item{odeModel}{a object of class \code{\link{odeModel}} from the package seeds. The class saves the details of an experiment for easier manipulation and analysis.}

\item{alphaStep}{the starting stepsize for the gradient descent
a fitting stepsize will be calculated based on a backtracking line search
if the algorithm converges to slow use a bigger stepsize}

\item{Beta}{scaling parameter for the backtracking to approximate the stepsize of the gradient descent. Is set to  0.8
if no value is given to the function}

\item{alpha1}{L1-norm parameter of the dynamic elastic net approach, is set to zero for this algorithm}

\item{alpha2}{L2-norm parameter of the dynamic elastic net approach
used for regulation purposes}

\item{x0}{initial state of the ODE system. Can be supplied with  the odeModel class.}

\item{optW}{a vector that indicates for which knots of the network a input should be calculated. The default is all nodes.}

\item{measFunc}{a R-Function that is used for measurement of the states if the system is not completely
measurable; an empty argument will result in the assumption that all states of the system are
measurable. Can be supplied by the odeModel parameter.}

\item{measData}{a table that contains the measurements of the experiment. Used to calculate the needed inputs. Can be supplied with  the odeModel class.}

\item{sd}{Standard deviation of the measurement. Is used to weight the errors of the estimates in the cost function. Optional parameter. Can be supplied with  the odeModel class. Should contain the time in the first column}

\item{epsilon}{parameter that defines the stopping criteria for the algorithm, in this case percent change in cost function J[w]}

\item{parameters}{vector or named vector that contains the parameters of the ODE equation. Can be supplied with  the odeModel class.}

\item{systemInput}{A dataset that describes the external input of the system. The time steps should be given in the first column for the interpolation.}

\item{modelFunc}{a R-Function that states the ODE system for which the hidden inputs should be calculated. Can be supplied with  the odeModel class.}

\item{greedyLogical}{a boolean that states if the greedy approach should be used;if set to FALSE the algorithm
will only use perform a calculation of the inputs for all knots without a sparse solution}

\item{plotEstimates}{boolean that indicated if the current estimate should be plotted.}

\item{conjGrad}{Boolean that indicates the usage of conjugate gradient method over the normal steepest descent. Defaults to true if not specified.}

\item{cString}{Optional parameter: A string that represents constants, can be used to calculate a hidden input for a component that gradient is zero.}

\item{nnStates}{A bit vector indicating the states that should be non negative. Default behaviour will calculate positive and negative states. Can be supplied with  the odeModel class.}

\item{verbose}{Boolean indicating if an output in the console should be created to display the gradient descent steps}
}
\value{
returns a list of results objects. The default plot function can be used to plot the results.
}
\description{
The sparse gradient dynamic elastic net calculates controls based on a first optimization with gradient descent. IT should 
result in a sparse vector of hidden inputs. These hidden inputs try to minimize the discrepancy between a given model and the taken measurements.
}
\details{
This algorithm uses a greedy approach to calculate the hidden inputs. Starting with a first estimation of the hidden inputs
the algorithm tries to optimize set of hidden inputs based on the area under the curve from the first run. The algorithm stops 
if a set of hidden gives a lower cost than a set with additional hidden inputs. 

For a complete example of the usage take a look into the vignette of the package.
}
\examples{
\donttest{
data(uvbModel)

results <- DEN(odeModel = uvbModel, alphaStep = 500, alpha2 = 0.0001,
                epsilon = 0.2, plotEstimates = TRUE)
}

}
