% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tximport.R
\name{getTx2gene}
\alias{getTx2gene}
\title{Get mapping between transcripts and genes}
\usage{
getTx2gene(
  organism = "mmusculus",
  version = NULL,
  outputDir = "data",
  checkArgsOnly = FALSE
)
}
\arguments{
\item{organism}{String used to pass \code{paste0(organism, "_gene_ensembl")} as the
\code{dataset} argument to \code{\link[biomaRt:useEnsembl]{biomaRt::useEnsembl()}}. To see available datasets,
do \verb{mart = biomaRt::useEnsembl("genes"); biomaRt::listDatasets(mart)}.}

\item{version}{Passed to \code{\link[biomaRt:useEnsembl]{biomaRt::useEnsembl()}}. \code{NULL} indicates the latest
version. To see available versions, do \code{biomaRt::listEnsemblArchives()}.}

\item{outputDir}{Directory in which to save the result, a file named
"tx2gene.csv.gz". If \code{NULL}, no file is saved.}

\item{checkArgsOnly}{Logical indicating whether to only check function
arguments. Used for testing.}
}
\value{
If \code{checkArgsOnly} is \code{FALSE}, a data.table based on the result from
\code{\link[biomaRt:getBM]{biomaRt::getBM()}}, with an attribute "version". Otherwise \code{0}.
}
\description{
This function uses the
\href{https://doi.org/doi:10.18129/B9.bioc.biomaRt}{biomaRt package}.
}
