% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_sys_deps.R
\name{installSysDeps}
\alias{installSysDeps}
\title{Install seeker's system dependencies}
\usage{
installSysDeps(
  sraToolkitDir,
  minicondaDir,
  refgenieDir,
  rprofileDir,
  minicondaEnv = "seeker",
  refgenieGenomes = NULL,
  fastqscreenDir = NULL
)
}
\arguments{
\item{sraToolkitDir}{String indicating directory in which to install the
\href{https://github.com/ncbi/sra-tools}{SRA Toolkit}. Recommended to use "~",
the home directory. If \code{NULL}, the Toolkit will not be installed.}

\item{minicondaDir}{String indicating directory in which to install
\href{https://docs.conda.io/en/latest/miniconda.html}{Miniconda}. Recommended
to use "~", the home directory. If \code{NULL}, Miniconda will not be installed.}

\item{refgenieDir}{String indicating directory in which to store the
directory of genome assets from refgenie, which will be named
"refgenie_genomes". Recommended to use "~", the home directory. Only used
if \code{minicondaDir} is not \code{NULL}.}

\item{rprofileDir}{String indicating directory in which to create or modify
.Rprofile, which is run by R on startup. Common options are "~" or ".".}

\item{minicondaEnv}{String indicating name of the Miniconda environment in
which to install various conda packages (fastq-screen, fastqc, multiqc,
pigz, refgenie, salmon, and trim-galore).}

\item{refgenieGenomes}{Character vector indicating genome assets, such as
transcriptome indexes for \code{\link[=salmon]{salmon()}}, to pull from
\href{http://refgenomes.databio.org/index}{refgenomes} using refgenie. If
\code{NULL}, no assets are fetched.}

\item{fastqscreenDir}{String indicating directory in which to download the
genomes for \code{\link[=fastqscreen]{fastqscreen()}}. This takes a long time. If \code{NULL}, genomes are
not downloaded.}
}
\value{
\code{NULL}, invisibly
}
\description{
This function installs and configures the various programs required for
seeker to fetch and process RNA-seq data.
}
\seealso{
\code{\link[=seeker]{seeker()}}
}
