\name{songmeterdiag}
\alias{songmeterdiag}
\title{Songmeter file diagnostics and diagram}

\description{
This function looks for files generated by a SongMeter device (audio
digal recorders produced by the society Wildlife Acoustics) and checks
for possible missing or small files according to a predefined recording schedule.
}
\usage{
songmeterdiag(dir, start, end, frequency,
pch.exi = 1, pch.mis = 19,
col.exi = 1, col.mis = 2,
cex.exi = NULL, cex.mis = 0.5,
limits = FALSE, output="file", plot = FALSE)
}

\arguments{
  \item{dir}{a character vector, path to directory(ies) where the .wav files are
  stored. Typically a "Data" folder as generated by SongMeter devices.}
  \item{start}{a character vector, start date/time of the recording schedule as programmed on the
  SongMeter device, must be in the format "year-month-day hour:minute:second".}
  \item{end}{a character vector, end date/time of the recording schedule as programmed on the
  SongMeter device, must be in the format "year-month-day hour:minute:second".}
  \item{frequency}{a numeric vector, frequency of the recording schedule expressed in minute.}
  \item{pch.exi}{symbol for plotting the existing file(s).}
  \item{pch.mis}{symbol for plotting the missing file(s)}
  \item{col.exi}{colour of the symbol for plotting the existing file(s).}
  \item{col.mis}{colour of the symbol for plotting the missing file(s).}
  \item{cex.exi}{size of the symbol for plotting the existing file(s),
    by default \code{NULL} so that the size of the symbol corresponds to
    the size of the .wav file in Mb divided by the average size of all
    .wav files found in the directory. If not NA then symbol size
    as in \code{\link{plot}}.}
  \item{cex.mis}{size of the symbol for plotting the missing file(s).}
  \item{limits}{a logical, if \code{TRUE} adds to the plot the limits
  (start and end date/time) of the recording schedule as programmed on
  the SongMeter device.}
  \item{output}{a character vector of length 1, either "file" or "time"
  to get the file name or the time slot in POSIXct format respectively.}
  \item{plot}{a logical, if \code{TRUE} plots a time plot indicating the
  existing and missing files (by default \code{TRUE}).}
}

\details{
  The function works for a single or several directories so that the
  operation of several SongMeters can be compared visually. This
  function should be helpful to check quickly how the devices worked.
}

\value{A character vector with the names of the missing files.}

\references{See Wildlife Acoustics website for details regarding the
  SongMeters 2, 3 and 4: \url{http://www.wildlifeacoustics.com/}}

\author{Jerome Sueur and Sylvain Haupert}

\note{The file names of Songmeters may change with time. There is no
  guarantee that the function will be perfectly updated.}

\seealso{\code{\link{songmeter}}}

\examples{
\dontrun{
##################
# simulated data
##################
# a recording schedule programmed on four SongMeters SM4
# named "S4A03895", "S4A03998", "S4A03536", and "S4A04430"
# starting the 1st of January 2019 at 00:00:00
# and stopping the 31st January 2019 at 23:30:00
# with a recording frequency of 30 minutes
# all directories stored in a single directory named "project" 
# recorder names
recorders <- c("S4A03895", "S4A03998", "S4A03536", "S4A04430")
n <- length(recorders)
# schedule as programmed on the devices
format <- "%Y%m%d_%H%M%S"
start <- strptime("20190101_000000", format) 
end <- strptime("20190131_233000", format)
schedule <- seq(from=start, to=end, by=30*60)
schedule <- paste(format(schedule, "%Y%m%d_%H%M%S"), ".wav", sep="")
# directories and files
dir.create("project")
for(i in 1:n) {
dir.create(paste("project", recorders[i], sep="/"))
}
for(i in 1:n) {
file.create(paste("project", recorders[i],
paste(recorders[i], each=schedule, sep="_"), sep="/"))
}
# removing some files to simulate missing files
dirs <- paste("project", recorders, sep="/")
file.remove(paste(dirs[1], dir(dirs[1])[200:500], sep="/"))

######################
# use of the function
######################
# directories where the .wav files are stored (as above)
dirs <- paste("project", recorders, sep="/")
# function call with a plot, cex.exi is here specify because we deal
# with ghost files (the .wav file are not truly created)
res <- songmeterdiag(dirs,
                     start="2019-01-01 00:00:00", end="2019-01-31 23:30:00", frequency=30,
                     cex.exi=1,  plot=TRUE)
# clear out
unlink("project", recursive=TRUE)
}
}

\keyword{input}
\keyword{data}
