% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/votes_get_results.R
\name{votes_get_results}
\alias{votes_get_results}
\title{Getting voting's results for each club}
\usage{
votes_get_results(page)
}
\arguments{
\item{page}{club's voting's results page}
}
\value{
data frame with two columns: deputy, vote
}
\description{
Function \code{votes_get_results} gets voting's results for each club.
}
\details{
Function \code{votes_get_results} gets voting's results for each club.
Example of page with voting's results of PO club: 
http://www.sejm.gov.pl/Sejm7.nsf/agent.xsp?symbol=klubglos&
IdGlosowania=37494&KodKlubu=PO
}
\note{
All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
page <- paste0('http://www.sejm.gov.pl/Sejm7.nsf/agent.xsp?',
           'symbol=klubglos&IdGlosowania=37494&KodKlubu=PO')
votes_get_results(page)}

}
\author{
Piotr Smuda
}

