% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{elem_hover}
\alias{elem_hover}
\title{Hover over an element}
\usage{
elem_hover(x, js = FALSE, timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{js}{Whether to hover the element using JavaScript.}

\item{timeout}{How long to wait for the element to exist.}
}
\value{
\code{x}, invisibly.
}
\description{
Move the mouse over to an HTML element and hover over it, without actually
clicking or interacting with it.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<button onmouseover = settext()> </button>
<p class = 'text'></p>
"

js <- "
function settext() {
  document.getElementsByClassName('text').item(0).innerHTML = 'Button hovered!'
}
"

session <- minimal_selenider_session(html, js = js)

elem_expect(s(".text"), has_exact_text(""))

s("button") |>
  elem_hover()

elem_expect(s(".text"), has_text("Button hovered!"))

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other actions: 
\code{\link{elem_click}()},
\code{\link{elem_scroll_to}()},
\code{\link{elem_set_value}()},
\code{\link{elem_submit}()}
}
\concept{actions}
