% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_all.R
\name{elem_expect_all}
\alias{elem_expect_all}
\alias{elem_wait_until_all}
\title{Test conditions on multiple elements}
\usage{
elem_expect_all(x, ..., testthat = NULL, timeout = NULL)

elem_wait_until_all(x, ..., timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_elements()} object.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Function calls or functions
that must return a logical value. If multiple conditions are given, they
must all be \code{TRUE} for the test to pass. See \code{\link[=elem_expect]{elem_expect()}} for more
details.}

\item{testthat}{Whether to treat the expectation as a \code{testthat} test. You
\emph{do not} need to explicitly provide this most of the time, since by
default, we can use \code{\link[testthat:is_testing]{testthat::is_testing()}} to figure out whether
\code{elem_expect()} is being called from within a \code{testthat} test.}

\item{timeout}{The number of seconds to wait for a condition to pass. If not
specified, the timeout used for \code{x} will be used, or the timeout of the
local session if an element is not given.}
}
\value{
\code{elem_expect_all()} returns \code{x}, invisibly.

\code{elem_wait_until_all()} returns a boolean flag: TRUE if the test passes,
FALSE otherwise.
}
\description{
\code{elem_expect_all()} and \code{elem_wait_until_all()} are complements to
\code{\link[=elem_expect]{elem_expect()}} and \code{\link[=elem_wait_until]{elem_wait_until()}} that test conditions on
multiple elements in an element collection.
}
\details{
If \code{x} does not contain any elements, \code{elem_expect_all()} and
\code{elem_wait_until_all()} will succeed. You may want to first verify that
at least one element exists with \code{\link[=has_at_least]{has_at_least()}}.

\code{elem_expect_all()} and \code{elem_wait_until_all()} can be thought of as
alternatives to the use of \code{all(vapply(FUN.VALUE = logical(1)))} (or
\code{\link[purrr:every]{purrr::every()}}) within \code{\link[=elem_expect]{elem_expect()}} and \code{\link[=elem_wait_until]{elem_wait_until()}}.

For example, the following two expressions are equivalent (where \code{x} is an
element collection).

\if{html}{\out{<div class="sourceCode">}}\preformatted{elem_expect(
  x,
  \\(element) all(vapply(as.list(element), is_present, logical(1)))
)
elem_expect_all(x, is_present)
}\if{html}{\out{</div>}}

However, the second example will give a more detailed error message on
failure.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div id='div1'>Content 1</div>
<div id='div2'>Content 2</div>
<div id='div3' style='display:none;'>Content 3</div>
<div id='div4'>Content 4</div>
"

session <- minimal_selenider_session(html)

ss("div") |>
  elem_expect_all(is_visible, timeout = 0.1) |>
  try()

ss("div")[-3] |>
  elem_expect_all(is_visible)

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=elem_expect]{elem_expect()}} and \code{\link[=elem_wait_until]{elem_wait_until()}}.
\item \code{\link[=is_present]{is_present()}} and other conditions for predicates for HTML elements.
(If you scroll down to the \emph{See also} section, you will find the rest).
}
}
