% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{has_length}
\alias{has_length}
\alias{has_size}
\alias{has_at_least}
\title{Does a collection have a certain number of elements?}
\usage{
has_length(x, n)

has_size(x, n)

has_at_least(x, n)
}
\arguments{
\item{x}{A \code{selenider_elements} object.}

\item{n}{A numeric vector of possible lengths of \code{x}. For \code{has_at_least()},
this must be a single number to compare to the length of \code{x}.}
}
\value{
A boolean value: \code{TRUE} or \code{FALSE}
}
\description{
\code{has_length()} and \code{has_size()} checks that a collection of HTML elements
contains a certain number of elements.
}
\details{
\code{has_at_least()} checks that a collection contains \emph{at least} \code{n} elements.

These functions do not implement a retry mechanism, and only test a condition
once. Use \code{\link[=elem_expect]{elem_expect()}} or \code{\link[=elem_wait_until]{elem_wait_until()}} to use these conditions in
tests.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div class='div1'></div>
<div class='div2'></div>
<div class='div3'></div>
"
session <- minimal_selenider_session(html)

has_length(ss("div"), 3)
has_at_least(ss("div"), 2)

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other conditions: 
\code{\link{has_attr}()},
\code{\link{has_css_property}()},
\code{\link{has_name}()},
\code{\link{has_text}()},
\code{\link{is_enabled}()},
\code{\link{is_present}()},
\code{\link{is_visible}()}
}
\concept{conditions}
