## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(semboottools)
library(lavaan)

## ----eval = FALSE-------------------------------------------------------------
# hist_qq_boot <- function(object,
#                       param,
#                       standardized = NULL,
#                       nclass = NULL,
#                       hist_color = "#5DADE233",
#                       hist_linewidth = 1.5,
#                       hist_border_color = "#1B4F72",
#                       density_line_type = "solid",
#                       density_line_color = "#8B0000CC",
#                       density_line_linewidth = 2,
#                       est_line_color = "#154360",
#                       est_line_type = "dashed",
#                       est_line_linewidth = 2,
#                       qq_dot_pch = 21,
#                       qq_dot_color = "#1B4F72",
#                       qq_dot_fill = "#5DADE233",
#                       qq_dot_size = 1.3,
#                       qq_line_color = "#8B0000CC",
#                       qq_line_linewidth = 2.1,
#                       qq_line_linetype = "solid"
#                       )
# 
# scatter_boot <- function(object,
#                          params,
#                          standardized = NULL,
#                          main = "Bootstrap Estimates",
#                          )

## -----------------------------------------------------------------------------
library(lavaan)

# Simulate data
set.seed(1234)
n <- 200
x <- runif(n) - 0.5
m <- 0.4 * x + rnorm(n)
y <- 0.3 * m + rnorm(n)
dat <- data.frame(x, m, y)

# Specify model
model <- '
  m ~ a * x
  y ~ b * m + cp * x
  ab := a * b
'

# Fit model
fit1 <- sem(model, data = dat, se = "boot", bootstrap = 1000)
fit2 <- sem(model, data = dat, fixed.x = FALSE)

## ----fig.width = 6, fig.height = 3,fig.align='center'-------------------------
fit1 <- store_boot(fit1)
hist_qq_boot(fit1, param = "ab", standardized = FALSE)


## -----------------------------------------------------------------------------
scatter_boot(fit1, c("ab", "a", "b"), standardized = FALSE)

## ----fig.width = 6, fig.height = 3, fig.align='center'------------------------
fit2 <- store_boot(fit2)
hist_qq_boot(fit2, param = "ab", standardized = TRUE)

## -----------------------------------------------------------------------------
scatter_boot(fit2, c("a", "b", "ab"), standardized = TRUE)

