% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglike_at.R
\name{plot.loglike_compare}
\alias{plot.loglike_compare}
\title{Plot the Output of 'loglike_compare()'}
\usage{
\method{plot}{loglike_compare}(
  x,
  y,
  type = c("ggplot2", "default"),
  size_label = 4,
  size_point = 4,
  nd_theta = 3,
  nd_pvalue = 3,
  size_theta = 4,
  size_pvalue = 4,
  add_pvalues = FALSE,
  ...
)
}
\arguments{
\item{x}{The output of \code{\link[=loglike_compare]{loglike_compare()}}.}

\item{y}{Not used.}

\item{type}{Character. If \code{"ggplot2"}, will use \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
to plot the graph. If \code{"default"}, will use R base graphics, The
\code{ggplot2} version plots more information. Default is \code{"ggplot2"}.}

\item{size_label}{The relative size of the labels for thetas
(and \emph{p}-values, if requested) in the
plot, determined by \code{\link[ggplot2:element]{ggplot2::rel()}}. Default is 4.}

\item{size_point}{The relative size of the points to be added
if \emph{p}-values are requested in the
plot, determined by \code{\link[ggplot2:element]{ggplot2::rel()}}. Default is 4.}

\item{nd_theta}{The number of decimal places for the labels
of theta. Default is 3.}

\item{nd_pvalue}{The number of decimal places for the labels
of \emph{p}-values. Default is 3.}

\item{size_theta}{Deprecated. No longer used.}

\item{size_pvalue}{Deprecated. No longer used.}

\item{add_pvalues}{If \code{TRUE}, likelihood ratio test \emph{p}-values will
be included for the confidence limits. Only available if \code{type = "ggplot2"}.}

\item{...}{Optional arguments. Ignored.}
}
\value{
Nothing if \code{type = "default"}, the generated \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
graph if \code{type = "ggplot2"}.
}
\description{
Visualize the log profile likelihood of a parameter
fixed to values in a range.
}
\details{
Given the output of \code{\link[=loglike_compare]{loglike_compare()}}, it plots the log
profile likelihood based on quadratic approximation and that
based on the original log-likelihood. The log profile likelihood
is scaled to have a maximum of zero (at the point estimate) as
suggested by Pawitan (2013).
}
\examples{

## loglike_compare

library(lavaan)
data(simple_med)
dat <- simple_med
mod <-
"
m ~ a * x
y ~ b * m
ab := a * b
"
fit <- lavaan::sem(mod, simple_med, fixed.x = FALSE)

# Four points are used just for illustration
# At least 21 points should be used for a smooth plot
# Remove try_k_more in real applications. It is set
# to run such that this example is not too slow.
# use_pbapply can be removed or set to TRUE to show the progress.
ll_a <- loglike_compare(fit, par_i = "m ~ x", n_points = 4,
                        try_k_more = 0,
                        use_pbapply = FALSE)

plot(ll_a)
plot(ll_a, add_pvalues = TRUE)

# See the vignette "loglike" for an example for the
# indirect effect.

}
\references{
Pawitan, Y. (2013). \emph{In all likelihood: Statistical
modelling and inference using likelihood}. Oxford University Press.
}
