% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presenter.R, R/semnar-package.R
\name{get_presenter.semnar}
\alias{get_presenter.semnar}
\alias{get_presenter}
\title{Get presenter information from a \code{\link{semnar}} object}
\usage{
\method{get_presenter}{semnar}(object)

get_presenter(object)
}
\arguments{
\item{object}{either an object an object of class \code{\link{semnar}}.}
}
\value{
A list of \code{\link{semnar_presenter}} objects, with the unique presenters in the \code{object}.
}
\description{
Get presenter information from a \code{\link{semnar}} object
}
\examples{
library("magrittr")
out <- add_presentation(presenter_name = "Ioannis",
                        presenter_surname = "Kosmidis",
                        presenter_affiliation = "University of Warwick",
                        title = "A") \%>\%
       add_presentation(presenter_name = "Ioannis",
                        presenter_surname = "Kosmidis",
                        presenter_affiliation = "University College London",
                        title = "B") \%>\%
       add_presentation(presenter_name = "Ioannis",
                        presenter_surname = "Kosmidis",
                        presenter_affiliation = "University College London",
                        title = "C")
get_presenter(out)
}
\seealso{
\code{\link{presenter}} \code{\link{set_presenter}}
}
