% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_layout.R
\name{rescale_layout}
\alias{rescale_layout}
\title{Rescale the Layout}
\usage{
rescale_layout(semPaths_plot, x_min = -1, x_max = 1, y_min = -1, y_max = 1)
}
\arguments{
\item{semPaths_plot}{A
\link[qgraph:qgraph]{qgraph::qgraph} object generated by
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}, or a similar
qgraph object modified by other
\link{semptools} functions.}

\item{x_min, x_max, y_min, y_max}{The
ranges of x-coordinates and
y-coordinates after rescaling.
Default is -1 for \code{x_min} and
\code{y_min}, and 1 for \code{x_max} and
\code{y_max}. Change them to enlarge or
shrink the plot.}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} based on
the original one, with the layout
matrix rescaled.
}
\description{
Rescale the layout of a
\code{qgraph} object, such as the output
of \code{semptools} functions that modify
the output of \code{\link[semPlot:semPaths]{semPlot::semPaths()}}.
}
\details{
The plot generated by some
functions, such as
\code{\link[=set_sem_layout]{set_sem_layout()}}, may have the area
underused for some model. This
function rescale the layout matrix,
just like what the \code{rescale} argument
of \code{\link[semPlot:semPaths]{semPlot::semPaths()}} does.
}
\examples{

library(lavaan)
library(semPlot)
mod <-
  'f1 =~ x01 + x02 + x03
   f3 =~ x08 + x09 + x10
   f4 =~ x11 + x12 + x13 + x14
   f3 ~ f1 + x04
   f4 ~ f3 + x05'
fit_sem <- sem(mod, sem_example)
p <- semPaths(fit_sem, whatLabels="est",
              sizeMan = 5,
              nCharNodes = 0,
              nCharEdges = 0,
              edge.width = 0.8,
              node.width = 0.7,
              edge.label.cex = 0.6,
              mar = c(10, 10, 10, 10),
              DoNotPlot = TRUE)
plot(p)

indicator_order  <- c("x04", "x05", "x01", "x02", "x03",
                      "x11", "x12", "x13", "x14", "x08", "x09", "x10")
indicator_factor <- c("x04", "x05", "f1",  "f1",  "f1",
                      "f4",  "f4",  "f4",  "f4",  "f3",  "f3",  "f3")
factor_layout <- matrix(c( "f1",  "f3", "f4",
                          "x04", "x05",  NA), byrow = TRUE, 2, 3)
factor_point_to <- matrix(c("left", "up", "right",
                                NA,   NA,      NA), byrow = TRUE, 2, 3)
p2 <- set_sem_layout(p,
                    indicator_order = indicator_order,
                    indicator_factor = indicator_factor,
                    factor_layout = factor_layout,
                    factor_point_to = factor_point_to)
# The original plot with too much unused area
plot(p2)
rect(-1, -1, 1, 1)
rect(-1.5, -1.5, 1.5, 1.5)

# Expand the plot
p3 <- p2
p3 <- rescale_layout(p3)

plot(p3)
rect(-1, -1, 1, 1)
rect(-1.5, -1.5, 1.5, 1.5)

}
