% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varimp.R
\name{varimp}
\alias{varimp}
\alias{plot.semforest.varimp}
\alias{varimpConvergencePlot}
\alias{print.semforest.varimp}
\title{SEM Forest Variable Importance}
\usage{
varimp(
  forest,
  var.names = NULL,
  verbose = F,
  eval.fun = evaluateTree,
  method = "permutation",
  conditional = FALSE,
  ...
)
}
\arguments{
\item{forest}{A \code{\link{semforest}} object}

\item{var.names}{Covariates used in the forest creation process. NULL value
will be automatically filled in by the function.}

\item{verbose}{Boolean to print messages while function is running.}

\item{eval.fun}{Default is \code{\link{evaluateTree}} function. The value of
the -2LL of the leaf nodes is compared to baseline overall model.}

\item{method}{Experimental. Some alternative methods to compute importance.
Default is "permutation".}

\item{conditional}{Conditional variable importance if TRUE, otherwise
marginal variable importance.}

\item{\dots}{Optional arguments.}
}
\description{
A function to calculate relative variable importance for selecting node
splits over a \code{\link{semforest}} object.
}
\references{
Brandmaier, A.M., Oertzen, T. v., McArdle, J.J., & Lindenberger,
U. (2013). Structural equation model trees. \emph{Psychological Methods},
18(1), 71-86.
}
\author{
Andreas M. Brandmaier, John J. Prindle
}
