% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_envi_format.R
\name{fix_envi_format}
\alias{fix_envi_format}
\title{Fix ENVI outputs}
\usage{
fix_envi_format(infiles)
}
\arguments{
\item{infiles}{A vector of input filenames, in the
sen2r naming convention (\link{safe_shortname}) and ENVI format.}
}
\value{
NULL (the function is called for its side effects)
}
\description{
Internal function which changes some elements of output ENVI
files:
\itemize{
\item file extension is set to .dat if .envi (in case of files created
by 'writeRaster`) is found, and the header is edited properly,
\item and band names are set in the header file (in particular, SR band names
include wavelengths and names like NIR, SWIR; other products shows the
product name as band name);
\item SCL headers include information about class names and colours.
}
}
\note{
License: GPL 3.0
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
