% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_indices.R
\name{list_indices}
\alias{list_indices}
\title{List spectral indices}
\usage{
list_indices(values, pattern = "", all = FALSE)
}
\arguments{
\item{values}{A vector of attributes which will be returned, being
one or more within the followings:
\itemize{
\item \code{n_index}: internal index identifiers;
\item \code{name}: index name;
\item \code{longname}: index description;
\item \code{link}: URL to the index description page;
\item \code{s2_formula}: expression containing the formula to compute the index;
\item \code{s2_formula_mathml}: MathML version of the formula;
\item \code{checked}: logical (TRUE for verified indices);
\item \code{a}, \code{b}, \code{x}: parameter values (NA for non required parameters).
}}

\item{pattern}{A regular expression on index names.}

\item{all}{Logical: if TRUE, all the indices retrieved from
\href{https://www.indexdatabase.de/db/is.php?sensor_id=96}{IDB} are returned;
if FALSE (default), only indices checked by the authors are returned.}
}
\value{
A data.frame with the required information. The table contains
also the following attributes:
\itemize{
\item \code{creation_date}: timestamp of the creation date of the indices archive;
\item \code{pkg_version}: version of the \code{sen2r} package used to
create the indices archive.
}
}
\description{
Return a table with attributes of the spectral indices
computable with the package.
}
\note{
License: GPL 3.0
}
\examples{
# Show index names
list_indices(c("name","longname"))

# Return the MSAVI2 formula
list_indices("s2_formula", "^MSAVI2$")

# Return all index names (including unchecked)
list_indices("name", all = TRUE)
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
