% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic-templates.R
\name{dynamic_template_data}
\alias{dynamic_template_data}
\title{Add dynamic template data}
\usage{
dynamic_template_data(sg_mail, data)
}
\arguments{
\item{sg_mail}{(required) mail object from package}

\item{data}{A key-value list for template data. (See \url{https://docs.sendgrid.com/ui/sending-email/how-to-send-an-email-with-dynamic-transactional-templates})}
}
\value{
sg_mail class with template data for dynamic transactional templates
}
\description{
\code{template_id} must be included for this data to be applied.
}
\examples{
data_lst <-
  list(
    first_name = "Amanda",
    link = "foo"
  )

mail() \%>\%
  template_id("d-4ad23ad40a0e47d0a0232b85f24ca5c2")\%>\%
  dynamic_template_data(data_lst)
}
