% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intra_samp_phylm.R
\name{intra_samp_phylm}
\alias{intra_samp_phylm}
\title{Interaction between intraspecific variability and species sampling - Phylogenetic Linear Regression}
\usage{
intra_samp_phylm(formula, data, phy, n.sim = 10, n.intra = 3,
  breaks = seq(0.1, 0.5, 0.1), model = "lambda", Vy = NULL, Vx = NULL,
  distrib = "normal", y.transf = NULL, x.transf = NULL, track = TRUE,
  ...)
}
\arguments{
\item{formula}{The model formula}

\item{data}{Data frame containing species traits with row names matching tips
in \code{phy}.}

\item{phy}{A phylogeny (class 'phylo') matching \code{data}.}

\item{n.sim}{The number of times species are randomly deleted for each
\code{break}.}

\item{n.intra}{Number of datasets resimulated taking into account intraspecific variation (see: \code{"intra_phylm"})}

\item{breaks}{A vector containing the percentages of species to remove.}

\item{model}{The phylogenetic model to use (see Details). Default is \code{lambda}.
#' @param Vy Name of the column containing the standard deviation or the standard error of the response 
variable. When information is not available for one taxon, the value can be 0 or \code{NA}.}

\item{Vy}{Name of the column containing the standard deviation or the standard error of the response 
variable. When information is not available for one taxon, the value can be 0 or \code{NA}.}

\item{Vx}{Name of the column containing the standard deviation or the standard error of the predictor 
variable. When information is not available for one taxon, the value can be 0 or \code{NA}}

\item{distrib}{A character string indicating which distribution to use to generate a random value for the response 
and/or predictor variables. Default is normal distribution: "normal" (function \code{\link{rnorm}}).
Uniform distribution: "uniform" (\code{\link{runif}})
Warning: we recommend to use normal distribution with Vx or Vy = standard deviation of the mean.}

\item{y.transf}{Transformation for the response variable (e.g. \code{"log"} or \code{"sqrt"}). Please use this 
argument instead of transforming data in the formula directly (see also details below).}

\item{x.transf}{Transformation for the predictor variable (e.g. \code{"log"} or \code{"sqrt"}). Please use this 
argument instead of transforming data in the formula directly (see also details below).}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{phylolm}}
}
\value{
The function \code{samp_phylm} returns a list with the following
components:

\code{formula}: The formula

\code{full.model.estimates}: Coefficients, aic and the optimised
value of the phylogenetic parameter (e.g. \code{lambda} or \code{kappa}) for
the full model without deleted species.

\code{sensi.estimates}: A data frame with all simulation
estimates. Each row represents a model rerun with a given number of species
\code{n.remov} removed, representing \code{n.percent} of the full dataset.
Columns report the calculated regression intercept (\code{intercept}),
difference between simulation intercept and full model intercept (\code{DIFintercept}),
the percentage of change in intercept compared to the full model (\code{intercept.perc})
and intercept p-value (\code{pval.intercept}). All these parameters are also reported
for the regression slope (\code{DIFestimate} etc.). Additionally, model aic value
(\code{AIC}) and the optimised value (\code{optpar}) of the phylogenetic
parameter (e.g. \code{kappa} or \code{lambda}, depending on the phylogenetic model
used) are reported. Lastly we reported the standardised difference in intercept 
(\code{sDIFintercept}) and slope (\code{sDIFestimate}).

\code{sign.analysis} For each break (i.e. each percentage of species
removed) this reports the percentage of statistically significant (at p<0.05)
intercepts (\code{perc.sign.intercept}) over all repetitions as well as the
percentage of statisticaly significant (at p<0.05) slopes (\code{perc.sign.estimate}).

\code{data}: Original full dataset.
}
\description{
Performs analyses of sensitivity to species sampling by randomly removing
species and detecting the effects on parameter estimates in a phylogenetic
linear regression, while taking into account potential
interactions with intraspecific variability.
}
\details{
This function randomly removes a given percentage of species (controlled by
\code{breaks}) from the full phylogenetic linear regression, fits a phylogenetic
linear regression model without these species using \code{\link[phylolm]{phylolm}},
repeats this many times (controlled by \code{n.sim}), stores the results and
calculates the effects on model parameters. 
This operation is repeated \code{n.intra} times for simulated values of the dataset, 
taking into account intraspecific variation. At each iteration, the function generates a 
random value for each row in the dataset using the standard deviation or errors supplied, and 
evaluates the effects of sampling within that iteration.

All phylogenetic models from \code{phylolm} can be used, i.e. \code{BM},
\code{OUfixedRoot}, \code{OUrandomRoot}, \code{lambda}, \code{kappa},
\code{delta}, \code{EB} and \code{trend}. See ?\code{phylolm} for details.

Currently, this function can only implement simple linear models (i.e. \eqn{trait~
predictor}). In the future we will implement more complex models.

Output can be visualised using \code{sensi_plot}.
}
\note{
Please be aware that dropping species may reduce power to detect 
significant slopes/intercepts and may partially be responsible for a potential 
effect of species removal on p-values. Please also consult standardised differences
in the (summary) output.
}
\examples{
\dontrun{
# Load data:
data(alien)
# Run analysis:
samp <- intra_samp_phylm(gestaLen ~ adultMass, phy = alien$phy[[1]],
                         y.transf = log,x.transf = NULL,Vy="SD_gesta",Vx=NULL,
                         data = alien$data, n.intra = 5, n.sim=10)
summary(samp)
head(samp$sensi.estimates)
# Visual diagnostics
sensi_plot(samp)
# You can specify which graph and parameter ("estimate" or "intercept") to print: 
sensi_plot(samp, graphs = 1)
sensi_plot(samp, graphs = 2)
}
}
\references{
Werner, G.D.A., Cornwell, W.K., Sprent, J.I., Kattge, J. & Kiers, E.T. (2014).
A single evolutionary innovation drives the deep evolution of symbiotic N2-fixation
in angiosperms. Nature Communications, 5, 4087.
  
Ho, L. S. T. and Ane, C. 2014. "A linear-time algorithm for 
Gaussian and non-Gaussian trait evolution models". Systematic Biology 63(3):397-408.
}
\seealso{
\code{\link[phylolm]{phylolm}},\code{\link{samp_phylm}}, 
\code{\link{intra_phylm}}, \code{\link{intra_samp_phyglm}},
\code{\link{sensi_plot}}
}
\author{
Gustavo Paterno, Gijsbert D.A. Werner & Caterina Penone
}
