% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samp_phyglm.R
\name{samp_phyglm}
\alias{samp_phyglm}
\title{Sensitivity Analysis Species Sampling  - Phylogenetic Logistic Regression}
\usage{
samp_phyglm(formula, data, phy, n.sim = 30, breaks = seq(0.1, 0.5, 0.1),
  btol = 50, track = TRUE, ...)
}
\arguments{
\item{formula}{The model formula}

\item{data}{Data frame containing species traits with row names matching tips
in \code{phy}.}

\item{phy}{A phylogeny (class 'phylo') matching \code{data}.}

\item{n.sim}{The number of times species are randomly deleted for each
\code{break}.}

\item{breaks}{A vector containing the percentages of species to remove.}

\item{btol}{Bound on searching space. For details see \code{phyloglm}}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{phyloglm}}
}
\value{
The function \code{samp_phylm} returns a list with the following
components:

\code{formula}: The formula

\code{full.model.estimates}: Coefficients, aic and the optimised
value of the phylogenetic parameter (e.g. \code{lambda} or \code{kappa}) for
the full model without deleted species.

\code{sensi.estimates}: A data frame with all simulation
estimates. Each row represents a model rerun with a given number of species
\code{n.remov} removed, representing \code{n.percent} of the full dataset.
Columns report the calculated regression intercept (\code{intercept}),
difference between simulation intercept and full model intercept (\code{DIFintercept}),
the percentage of change in intercept compared to the full model (\code{intercept.perc})
and intercept p-value (\code{pval.intercept}). All these parameters are also reported
for the regression slope (\code{DIFestimate} etc.). Additionally, model aic value
(\code{AIC}) and the optimised value (\code{optpar}) of the phylogenetic
parameter (e.g. \code{kappa} or \code{lambda}, depending on the phylogenetic model
used) are reported. Lastly we reported the standardised difference in intercept 
(\code{sDIFintercept}) and slope (\code{sDIFestimate}).

\code{sign.analysis} For each break (i.e. each percentage of species
removed) this reports the percentage of statistically significant (at p<0.05)
intercepts (\code{perc.sign.intercept}) over all repetitions as well as the
percentage of statisticaly significant (at p<0.05) slopes (\code{perc.sign.estimate}).

\code{data}: Original full dataset.
}
\description{
Performs analyses of sensitivity to species sampling by randomly removing
species and detecting the effects on parameter estimates in phylogenetic
logistic regression.
}
\details{
This function randomly removes a given percentage of species (controlled by
\code{breaks}) from the full phylogenetic logistic regression, fits a phylogenetic
logistic regression model without these species using \code{\link[phylolm]{phyloglm}},
repeats this many times (controlled by \code{n.sim}), stores the results and
calculates the effects on model parameters.

Only logistic regression using the "logistic_MPLE"-method from
\code{phyloglm} is implemented.

Currently, this function can only implement simple logistic models (i.e. \eqn{trait~
predictor}). In the future we will implement more complex models.

Output can be visualised using \code{sensi_plot}.
}
\note{
Please be aware that dropping species may reduce power to detect 
significant slopes/intercepts and may partially be responsible for a potential 
effect of species removal on p-values. Please also consult standardised differences
in the (summary) output.
}
\examples{
# Simulate Data:
set.seed(6987)
phy = rtree(100)
x = rTrait(n=1,phy=phy)
X = cbind(rep(1,100),x)
y = rbinTrait(n=1,phy=phy, beta=c(-1,0.5), alpha=.7 ,X=X)
dat = data.frame(y, x)
# Run sensitivity analysis:
samp <- samp_phyglm(y ~ x, data = dat, phy = phy, n.sim = 10) 
# To check summary results and most influential species:
summary(samp)
\dontrun{
# Visual diagnostics for clade removal:
sensi_plot(samp)
}
}
\references{
Werner, G.D.A., Cornwell, W.K., Sprent, J.I., Kattge, J. & Kiers, E.T. (2014).
 A single evolutionary innovation drives the deep evolution of symbiotic N2-fixation
  in angiosperms. Nature Communications, 5, 4087.
  
#' Ho, L. S. T. and Ane, C. 2014. "A linear-time algorithm for 
Gaussian and non-Gaussian trait evolution models". Systematic Biology 63(3):397-408.
}
\seealso{
\code{\link[phylolm]{phyloglm}}, \code{\link{samp_phylm}},
\code{\link{influ_phyglm}}, \code{\link{sensi_plot}}
}
\author{
Gustavo Paterno & Gijsbert D.A. Werner
}
