% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sobol.R
\name{plot_uncertainty}
\alias{plot_uncertainty}
\title{Visualization of the model output uncertainty}
\usage{
plot_uncertainty(Y, N = NULL)
}
\arguments{
\item{Y}{A numeric vector with the model output obtained from the matrix created with
\code{\link{sobol_matrices}}.}

\item{N}{Positive integer, the initial sample size of the base sample matrix created with \code{\link{sobol_matrices}}.}
}
\value{
A \code{ggplot2} object.
}
\description{
It creates an histogram with the model output distribution.
}
\examples{
# Define settings
N <- 1000; params <- paste("X", 1:3, sep = ""); R <- 10

# Create sample matrix
mat <- sobol_matrices(N = N, params = params)

# Compute Ishigami function
Y <- ishigami_Fun(mat)

# Plot uncertainty
plot_uncertainty(Y = Y, N = N)
}
