% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{JST}
\alias{JST}
\title{Create a Joint Sentiment/Topic model}
\usage{
JST(
  x,
  lexicon = NULL,
  S = 3,
  K = 5,
  gamma = 1,
  alpha = 5,
  beta = 0.01,
  gammaCycle = 0,
  alphaCycle = 0
)
}
\arguments{
\item{x}{tokens object containing the texts. A coercion will be attempted if \code{x} is not a tokens.}

\item{lexicon}{a \code{quanteda} dictionary with positive and negative categories}

\item{S}{the number of sentiments}

\item{K}{the number of topics}

\item{gamma}{the hyperparameter of sentiment-document distribution}

\item{alpha}{the hyperparameter of topic-document distribution}

\item{beta}{the hyperparameter of vocabulary distribution}

\item{gammaCycle}{integer specifying the cycle size between two updates of
the hyperparameter alpha}

\item{alphaCycle}{integer specifying the cycle size between two updates of
the hyperparameter alpha}
}
\value{
An S3 list containing the model parameter and the estimated mixture.
This object corresponds to a Gibbs sampler estimator with zero iterations.
The MCMC can be iterated using the \code{\link[=grow]{grow()}} function.
\itemize{
\item \code{tokens} is the tokens object used to create the model
\item \code{vocabulary} contains the set of words of the corpus
\item \code{it} tracks the number of Gibbs sampling iterations
\item \code{za} is the list of topic assignment, aligned to the \code{tokens} object with
padding removed
\item \code{logLikelihood} returns the measured log-likelihood at each iteration,
with a breakdown of the likelihood into hierarchical components as
attribute
}

The \code{\link[=topWords]{topWords()}} function easily extract the most probables words of each
topic/sentiment.
}
\description{
This function initialize a Joint Sentiment/Topic model.
}
\details{
The \code{rJST.LDA} methods enable the transition from a previously
estimated \link{LDA} model to a sentiment-aware \code{rJST} model. The function
retains the previously estimated topics and randomly assigns sentiment to
every word of the corpus. The new model will retain the iteration count of
the initial \link{LDA} model.
}
\examples{
\donttest{# creating a JST model
JST(ECB_press_conferences_tokens)

# estimating a JST model including a lexicon
jst <- JST(ECB_press_conferences_tokens, lexicon = LoughranMcDonald)
jst <- grow(jst, 100)}
}
\references{
Lin, C. and He, Y. (2009). \href{https://dl.acm.org/doi/10.1145/1645953.1646003}{Joint sentiment/topic model for sentiment analysis}. In \emph{Proceedings
of the 18th ACM conference on Information and knowledge management},
375--384.

Lin, C., He, Y., Everson, R. and Ruger, S. (2012). \href{https://ieeexplore.ieee.org/document/5710933}{Weakly Supervised Joint Sentiment-Topic Detection from Text}.
\emph{IEEE Transactions on Knowledge and Data Engineering}, 24(6), 1134–-1145.
}
\seealso{
Growing a model: \code{\link[=grow]{grow()}}, extracting top words: \code{\link[=topWords]{topWords()}}

Other topic models: 
\code{\link{LDA}()},
\code{\link{rJST}()},
\code{\link{sentopicmodel}()}
}
\author{
Olivier Delmarcelle
}
\concept{topic models}
