% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmute_nse.R
\name{transmute_nse}
\alias{transmute_nse}
\title{transmute non-standard evaluation interface.}
\usage{
transmute_nse(.data, ..., env = parent.frame())
}
\arguments{
\item{.data}{data.frame}

\item{...}{stringified expressions to transmute by.}

\item{env}{environment to work in.}
}
\value{
.data with altered columns(other columns dropped).
}
\description{
transmute a data frame by the transmuteTerms.  Accepts arbitrary text as
transmuteTerms to allow forms such as "Sepal.Length >= 2 * Sepal.Width".
Terms are vectors or lists of the form "lhs := rhs".
}
\examples{


resCol1 <- "Sepal_Long"
ratio <- 2
compCol1 <- "Sepal.Width"


datasets::iris \%.>\%
  transmute_nse(., resCol1 := "Sepal.Length" >= ratio * compCol1,
                "Petal_Short" := "Petal.Length" <= 3.5) \%.>\%
  summary(.)


}
\seealso{
\code{\link{transmute_se}}, \code{\link[dplyr]{transmute}}, \code{\link[dplyr]{transmute_at}}, \code{\link[wrapr]{:=}}
}
