% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stmtPlanner.R
\name{factor_mutate}
\alias{factor_mutate}
\title{Re-write a \code{dplyr::mutate()} into safe blocks.}
\usage{
factor_mutate(..., factor_mutate_warn_msg = TRUE)
}
\arguments{
\item{...}{mutate terms}

\item{factor_mutate_warn_msg}{logical if TRUE issue a warning message on non-trivial mutates.}
}
\value{
partitioned dplyr::mutate() source text
}
\description{
Note: not for use with \code{rlang} expressions (guesses variable names by text inspection).
See also: \url{https://winvector.github.io/rquery/articles/AssigmentPartitioner.html}.
}
\examples{

cat(factor_mutate(
 choice_a = rand_a >= 0.5,
   a_1 = ifelse(choice_a, 'T', 'C'),
   a_2 = ifelse(choice_a, 'C', 'T'),
  choice_b = rand_b >= 0.5,
   b_1 = ifelse(choice_b, 'T', 'C'),
   b_2 = ifelse(choice_b, 'C', 'T'),
  choice_c = rand_c >= 0.5,
   c_1 = ifelse(choice_c, 'T', 'C'),
   c_2 = ifelse(choice_c, 'C', 'T'),
  choice_d = rand_d >= 0.5,
   d_1 = ifelse(choice_d, 'T', 'C'),
   d_2 = ifelse(choice_d, 'C', 'T'),
  choice_e = rand_e >= 0.5,
   e_1 = ifelse(choice_e, 'T', 'C'),
   e_2 = ifelse(choice_e, 'C', 'T'),
 factor_mutate_warn_msg = FALSE ))

cat(factor_mutate(
 choice = rand_a >= 0.5,
   a_1 = ifelse(choice, 'T', 'C'),
   a_2 = ifelse(choice, 'C', 'T'),
  choice = rand_b >= 0.5,
   b_1 = ifelse(choice, 'T', 'C'),
   b_2 = ifelse(choice, 'C', 'T'),
  choice = rand_c >= 0.5,
   c_1 = ifelse(choice, 'T', 'C'),
   c_2 = ifelse(choice, 'C', 'T'),
  choice = rand_d >= 0.5,
   d_1 = ifelse(choice, 'T', 'C'),
   d_2 = ifelse(choice, 'C', 'T'),
  choice = rand_e >= 0.5,
   e_1 = ifelse(choice, 'T', 'C'),
   e_2 = ifelse(choice, 'C', 'T'),
 factor_mutate_warn_msg = FALSE))

}
