% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stmtPlanner.R
\name{partition_mutate_qt}
\alias{partition_mutate_qt}
\title{Partition a sequence of mutate commands into longest ordered no create/use blocks.}
\usage{
partition_mutate_qt(...)
}
\arguments{
\item{...}{mutate expressions with := used for assignment.}
}
\value{
ordered list of mutate_se assignment blocks
}
\description{
We assume the sequence of expressions is in a valid order
(all items available before use).  This function partitions the expressions
into ordered longest "no new value used blocks" by greedily scanning forward
remaining expressions in order taking any that: have all their values available from earlier groups,
do not use a value formed in the current group, and do not overwrite a value formed in the current group.
For an example please see \url{http://winvector.github.io/FluidData/partition_mutate.html}.
}
\details{
Note: unlike \code{\link{mutate_nse}} \code{partition_mutate_qt} does not perform
substitutions.
}
\examples{

plan <- partition_mutate_qt(a1 := 1, b1 := a1, a2 := 2, b2 := a1 + a2)
print(plan)
d <- data.frame(x = 1) \%.>\% mutate_seb(., plan)
print(d)


}
