% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_summarize.R
\name{group_summarize}
\alias{group_summarize}
\alias{group_summarise}
\title{group_by and summarize as an atomic action.}
\usage{
group_summarize(d, groupingVars, ..., arrangeTerms = NULL,
  env = parent.frame())

group_summarise(d, groupingVars, ..., arrangeTerms = NULL,
  env = parent.frame())
}
\arguments{
\item{d}{data.frame}

\item{groupingVars}{character vector of column names to group by.}

\item{...}{list of dplyr::mutate() expressions.}

\item{arrangeTerms}{character optional vector of column expressions to arrange by.}

\item{env}{environment to work in.}
}
\value{
d summarized by groups
}
\description{
Group a data frame by the groupingVars and compute user summaries on
this data frame (user summaries specified in ...).  Enforces the
good dplyr pipeline design principle of keeping group_by and
summarize close together.
Author: John Mount, Win-Vector LLC.
}
\examples{


group_summarize(datasets::mtcars,
                    c("cyl", "gear"),
                    group_mean_mpg = mean(mpg),
                    group_mean_disp = mean(disp)) \%.>\%
  head(.)

}
