% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stslist_to_data.R
\name{data_to_stslist}
\alias{data_to_stslist}
\alias{stslist_to_data}
\title{Transform TraMineR's state sequence object to data.table and vice versa}
\usage{
data_to_stslist(x, id, time, responses, seqdef_args = NULL, ...)

stslist_to_data(x, id, time, responses, ...)
}
\arguments{
\item{x}{For \code{data_to_stslist}, a \code{data.frame} type of object in long format,
or a model object of class \code{nhmm} or \code{mnhmm}.
For \code{stslist_to_data}, an object of class \code{stslist} or list of such objects.}

\item{id}{A character string specifying the id variable. Ignored if \code{x}
is NHMM.}

\item{time}{A character string specifying the time variable. Ignored if \code{x}
is NHMM.}

\item{responses}{A character vector specifying the name(s) of the response
variable(s). Ignored if \code{x} is NHMM.}

\item{seqdef_args}{A list of additional arguments to \code{\link[TraMineR:seqdef]{TraMineR::seqdef()}} in
case of  \code{data_to_stslist}. In case of \code{length(responses) > 1}, a list of
lists. Ignored in \code{stslist_to_data}.}

\item{...}{Ignored}
}
\description{
Transform TraMineR's state sequence object to data.table and vice versa
}
