% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenoConvert.R
\name{LHConvert}
\alias{LHConvert}
\title{Extract sex and birthyear from PLINK file}
\usage{
LHConvert(PlinkFile = NULL, UseFID = FALSE, SwapSex = TRUE,
  FIDsep = "__", LifeHistData = NULL)
}
\arguments{
\item{PlinkFile}{character string with name of genotype file to be converted}

\item{UseFID}{Use the family ID column. The resulting ids (rownames of GenoM)
will be in the form FID__IID}

\item{SwapSex}{change the coding from PLINK default (1=male, 2=female) to
sequoia default (1=female, 2=male); any other numbers are set to NA}

\item{FIDsep}{characters inbetween FID and IID in composite-ID. By default a
double underscore is used, to avoid problems when some IIDs contain an
underscore. Only used when UseFID=TRUE.}

\item{LifeHistData}{dataframe with additional sex and birth year info. In
case of conflicts, LifeHistData takes priority, with a warning. If
UseFID=TRUE, IDs in LifeHistData are assumed to be already as FID__IID.}
}
\value{
a dataframe with id, sex and birth year, which can be used as input
 for \code{\link{sequoia}}
}
\description{
Convert the first six columns of a PLINK .fam, .ped or
 .raw file into a three-column lifehistory file for sequoia. Optionally
  FID and IID are combined.
}
\details{
The first 6 columns of PLINK .fam, .ped and .raw files are by
default FID - IID - father ID (ignored) - mother ID (ignored) - sex -
phenotype.

When additionally a
}
\examples{
\dontrun{
# combine FID and IID in dataframe with additional sex & birth years
ExtraLH$FID_IID <- paste(ExtraLH$FID, ExtraLH$IID, sep = "__")
LH.new <- LHConvert(PlinkFile, UseFID = TRUE, FIDsep = "__",
                    LifeHistData = ExtraLH)
}

}
\seealso{
\code{\link{GenoConvert}}, \code{\link{PedStripFID}} to reverse
 \code{UseFID}
}
