% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPairLL.R
\name{PlotPairLL}
\alias{PlotPairLL}
\title{Plot Pair Log10-Likelihoods}
\usage{
PlotPairLL(
  PairLL,
  combo = list(c("FS", "PO"), c("HS", "FS"), c("GP", "HS"), c("FA", "HS")),
  nrows = NULL,
  ncols = NULL,
  bgcol = TRUE,
  Tassign = 0.5,
  Tfilter = -2
)
}
\arguments{
\item{PairLL}{dataframe, output from \code{\link{CalcPairLL}}.}

\item{combo}{list with length-2 character vectors, specifying which
likelihoods to plot against each other. Choose from 'PO', 'FS', 'HS', 'GP',
'FA', and 'HA'. The first one gets plotted on the x-axis, the second on the
y-axis. Subsequent figures will be drawn row-wise.}

\item{nrows}{number of rows in the figure layout. If \code{NULL}, set to
\code{ceiling(length(combo)/ncols)}.}

\item{ncols}{number of columns in the figure layout. If both \code{nrows} and
\code{ncols} are NULL, \code{ncols} is set to
\code{ceiling(sqrt(length(combo)))}, and \code{nrows} will be equal to
\code{ncols} or one less.}

\item{bgcol}{logical, colour the upper and lower triangle background of each
figure to match the specified relationship combo.}

\item{Tassign}{assignment threshold, shown as grey square in bottom-left
corner and a band along the diagonal.}

\item{Tfilter}{filter threshold, shown as dark grey square in bottom-left.}
}
\description{
Colour-coded scatter plots of e.g. LLR(PO/U) against LLR(FS/U),
  for various relationship combinations.
}
\details{
The colour of each point is determined by columns \code{focal}
  (outer circle) and \code{TopRel} (inner filling) of \code{PairLL}.

  Impossible relationships (LL > 0 in \code{PairLL}) are shown as \code{-Inf}
  on the axes, if any are present.
}
\examples{
data(SimGeno_example)
Pairs <- data.frame(ID1 = "a01005",
                    ID2 = c("a00013", "a00008", "a00011", "b00001",
                            "b01006", "b01007", "b01013", "b01014"),
                    focal = rep(c("PO", "HS"), each=4))
PLL <- CalcPairLL(Pairs, GenoM=SimGeno_example, Plot=FALSE)
PlotPairLL(PLL,
           combo = list(c("FS", "PO"), c("HS", "FS"), c("GP", "HS"),
                        c("FA", "HS"), c("HA", "FA"), c("FA", "GP")),
           nrows = 3)

}
\seealso{
\code{\link{CalcPairLL}}.
}
