% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jdbc.r
\name{drill_jdbc}
\alias{drill_jdbc}
\title{Connect to Drill using JDBC}
\usage{
drill_jdbc(nodes = "localhost:2181", cluster_id = NULL, schema = NULL,
  use_zk = TRUE)
}
\arguments{
\item{nodes}{character vector of nodes. If more than one node, you can either have
a single string with the comma-separated node:port pairs pre-made or
pass in a character vector with multiple node:port strings and the
function will make a comma-separated node string for you.}

\item{cluster_id}{the cluster id from \code{drill-override.conf}}

\item{schema}{an optional schema name to append to the JDBC connection string}

\item{use_zk}{are you connecting to a ZooKeeper instance (default: \code{TRUE}) or
connecting to an individual DrillBit.}
}
\value{
a JDBC connection object
}
\description{
The DRILL JDBC driver fully-qualified path must be placed in the
\code{DRILL_JDBC_JAR} environment variable. This is best done via \code{~/.Renviron}
for interactive work. e.g. \code{DRILL_JDBC_JAR=/usr/local/drill/jars/jdbc-driver/drill-jdbc-all-1.10.0.jar}
}
\examples{
\dontrun{
con <- drill_jdbc("localhost:2181", "main")
drill_query(con, "SELECT * FROM cp.`employee.json`")

# you can also use the connection with RJDBC calls:
dbGetQuery(con, "SELECT * FROM cp.`employee.json`")

# for local/embedded mode with default configuration info
con <- drill_jdbc("localhost:31010", use_zk=FALSE)
}
}
\references{
\url{https://drill.apache.org/docs/using-the-jdbc-driver/#using-the-jdbc-url-for-a-random-drillbit-connection}
}
