% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.curve.params.R
\name{graph.curve.params}
\alias{graph.curve.params}
\title{Graph estimated antibody decay curve}
\usage{
graph.curve.params(
  curve_params,
  antigen_isos = unique(curve_params$antigen_iso),
  verbose = FALSE
)
}
\arguments{
\item{curve_params}{a \code{\link[=data.frame]{data.frame()}} containing MCMC samples of antibody decay curve parameters}

\item{antigen_isos}{antigen isotypes}

\item{verbose}{verbose output}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Graph estimated antibody decay curve
}
\examples{
\donttest{
curve_params <- readRDS(url("https://osf.io/download/rtw5k/"))

plot1 <- graph.curve.params(curve_params)

print(plot1)
}
}
