% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tb_nl_1966_1973}
\alias{tb_nl_1966_1973}
\title{Tuberculosis serological data from the Netherlands 1966-1973 (aggregated)}
\format{
A data frame with 5 variables:
\describe{
 \item{age}{Age group}
 \item{pos}{Number of seropositive individuals}
 \item{tot}{Total number of individuals surveyed}
 \item{gender}{Gender of cohort (unsure what 0 and 1 means)}
 \item{birthyr}{Birth year of cohort}
}
}
\source{
Nagelkerke, N., Heisterkamp, S., Borgdorff, M., Broekmans, J. and
Van Houwelingen, H. (1999), Semi-parametric estimation of age-time specific
infection incidence from serial prevalence data. Statist. Med., 18: 307-320.
\doi{doi:10.1002/(SICI)1097-0258(19990215)18:3<307::AID-SIM15>3.0.CO;2-Z}
}
\usage{
tb_nl_1966_1973
}
\description{
A study of tuberculosis conducted in the Netherlands. Schoolchildren, aged
between 6 and 18 years, were tested using the tuberculin skin test.
}
\examples{
# Reproduce Fig 4.6, p.70
age <- tb_nl_1966_1973$age
birthyr <- tb_nl_1966_1973$birthyr
pos <- tb_nl_1966_1973$pos
tot <- tb_nl_1966_1973$tot
# left panel
plot(age, pos / tot,
  pch = 16, cex = 0.00005 * tot, xlab = "age",
  ylab = "prevalence", xlim = c(6, 18)
)
# right panel
plot(birthyr, pos / tot,
  pch = 16, cex = 0.00005 * tot, xlab = "year", ylab = "prevalence"
)

}
\keyword{datasets}
