% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_keywords}
\alias{sst_sa_keywords}
\title{Phrase match keywords}
\usage{
sst_sa_keywords(
  api_token,
  keyword,
  se,
  minusKeywords = NULL,
  sort = NULL,
  filters = NULL,
  page = 1,
  size = 100,
  return_method = "list"
)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{keyword}{(required) A keyword to search for.}

\item{se}{(required) Search engine alias (db_name) returned by
\code{\link{sst_sa_database_info}}.}

\item{minusKeywords}{(optional) A vector of words. Keywords in response
will not contain these words.}

\item{sort}{(optional) A field to sort the response. See Sorting for more
details.}

\item{filters}{(optional) A list of filtering options. See Filtering for more
details.}

\item{page}{(optional) Page number if there are many pages in response.}

\item{size}{(optional) Page size.
Optional parameters for filtering, sorting and walking through the pages of
the response are described
\href{https://serpstat.com/api/61-filtering-and-sorting-results/}{here}.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}
}
\value{
Returns
  \href{https://serpstat.com/api/29-phrase-match-keywords-keywords/}{a number
  of metrics} for each keyword.
}
\description{
A full-text search to find all the keywords that match the queried term with
a number of metrics for each keyword like search volume, CPC and competition
level.
}
\section{API rows consumption}{
 1 per keyword in response.
}

\section{Sorting}{

  You can sort the response using \code{sort} argument. It must be a list
  with a single named element. The name of the element must match one of
  parameters in response. The value of the element must be \code{asc} for
  ascending order and \code{desc} for descending order. For example,
  \code{sort = list(ads = 'desc')} would sort the response by \code{ads}
  parameter in descending order.
}

\section{Filtering}{

  To filter the results you can use \code{filters} argument. It must be a
  list of named elements. The name of the element must match one of the
  filtering parameters described
  \href{https://serpstat.com/api/61-filtering-and-sorting-results/}{here}.
  You can find all the acceptable values for each parameter there too. For
  example, \code{filters = list(queries_from = 0, queries_to = 10)} would
  narrow the results to include only the keywords that have a search volume
  between 0 and 10.
}

\examples{
api_token <- 'api_token'
sst_sa_keywords(
  api_token     = api_token,
  keyword       = 'serpstat',
  se            = 'g_us',
  minusKeywords = c('free'),
  sort          = list(keyword_length = 'asc'),
  page          = 2,
  size          = 10,
  return_method = 'df'
)$data
}
