% Generated by roxygen2 (4.0.2): do not edit by hand
\name{options_manager}
\alias{options_manager}
\title{Create a new options manager.}
\usage{
options_manager(...)
}
\arguments{
\item{...}{Comma separated \code{[name]=[value]} pairs. These will be the names and default values for your options manager.}
}
\value{
A \code{function} that can be used as a custom options manager. It takes as arguments
a comma separated list of option names (\code{character}) to retrieve options or
\code{[name]=[value]} pairs to set options.
}
\description{
Set up a set of options with default values and retrieve a manager for it.
}
\section{Details}{


The function \code{options_manager} creates an option management function. The returned
function can be uset to set, get, or reset options. The only restriction of the package is
that the following words cannot be used as names for options:

\code{.__reset} \code{.__defaults}

For more details and extensive examples see the vignette by copy-pasting this command:

   \code{vignette("settings", package = "options")}
}
\examples{
# create an options register
my_options <- options_manager(foo=1,bar=2,baz='bob')

### Retrieving options
my_options() # retrieve the full options list.
my_options('baz')
my_options('foo')

# When multiple options are retrieved, the result is a list
my_options('foo','baz')

### Setting global options
my_options(foo=3,baz='pete')
my_options()
### Reset options to default.
reset(my_options)
my_options()
}
\seealso{
Reset to default values: \code{\link{reset}}.

Retrieve default values: \code{\link{defaults}}

Create a local, possibly altered copy: \code{\link{clone_and_merge}}
}

