% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-volumecontent-collection.R
\name{VolumeContentCollection}
\alias{VolumeContentCollection}
\title{R6 Class representing a VolumeContentCollection}
\description{
R6 Class representing a resource for managing volume content collections.
}
\examples{

## ------------------------------------------------
## Method `VolumeContentCollection$print`
## ------------------------------------------------

\dontrun{
# x is API response when volume content collection is requested
vol_con_col_object <- VolumeContentCollection$new(
                    res = x,
                    href = x$href,
                    links = x$links,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print volume content collection object
 vol_con_col_object$print()
}


## ------------------------------------------------
## Method `VolumeContentCollection$next_page`
## ------------------------------------------------

\dontrun{
# x is API response when volume content collection is requested
vol_con_col_object <- VolumeContentCollection$new(
                    res = x,
                    href = x$href,
                    links = x$links,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get next page of results
 vol_con_col_object$next_page()
}


## ------------------------------------------------
## Method `VolumeContentCollection$prev_page`
## ------------------------------------------------

\dontrun{
# x is API response when volume content collection is requested
vol_con_col_object <- VolumeContentCollection$new(
                    res = x,
                    href = x$href,
                    links = x$links,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get previous page of results
 vol_con_col_object$prev_page()
}


## ------------------------------------------------
## Method `VolumeContentCollection$all`
## ------------------------------------------------

\dontrun{
# x is API response when volume content collection is requested
vol_con_col_object <- VolumeContentCollection$new(
                    res = x,
                    href = x$href,
                    links = x$links,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get all results
 vol_con_col_object$all()
}

}
\section{Super class}{
\code{\link[sevenbridges2:Collection]{sevenbridges2::Collection}} -> \code{VolumeContentCollection}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{prefixes}}{Prefixes on the volume, returned in API response.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VolumeContentCollection-new}{\code{VolumeContentCollection$new()}}
\item \href{#method-VolumeContentCollection-print}{\code{VolumeContentCollection$print()}}
\item \href{#method-VolumeContentCollection-next_page}{\code{VolumeContentCollection$next_page()}}
\item \href{#method-VolumeContentCollection-prev_page}{\code{VolumeContentCollection$prev_page()}}
\item \href{#method-VolumeContentCollection-all}{\code{VolumeContentCollection$all()}}
\item \href{#method-VolumeContentCollection-clone}{\code{VolumeContentCollection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeContentCollection-new"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeContentCollection-new}{}}}
\subsection{Method \code{new()}}{
Create new VolumeContentCollection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeContentCollection$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing VolumeContentCollection object fields.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeContentCollection-print"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeContentCollection-print}{}}}
\subsection{Method \code{print()}}{
Print method for VolumeContentCollection class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeContentCollection$print(n = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of items to print in console.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume content collection is requested
vol_con_col_object <- VolumeContentCollection$new(
                    res = x,
                    href = x$href,
                    links = x$links,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print volume content collection object
 vol_con_col_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeContentCollection-next_page"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeContentCollection-next_page}{}}}
\subsection{Method \code{next_page()}}{
Return next page of results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeContentCollection$next_page(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments or query parameters that can be passed to
core \code{api()} function like 'advance_access', 'fields' etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume content collection is requested
vol_con_col_object <- VolumeContentCollection$new(
                    res = x,
                    href = x$href,
                    links = x$links,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get next page of results
 vol_con_col_object$next_page()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeContentCollection-prev_page"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeContentCollection-prev_page}{}}}
\subsection{Method \code{prev_page()}}{
Return previous page of results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeContentCollection$prev_page()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume content collection is requested
vol_con_col_object <- VolumeContentCollection$new(
                    res = x,
                    href = x$href,
                    links = x$links,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get previous page of results
 vol_con_col_object$prev_page()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeContentCollection-all"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeContentCollection-all}{}}}
\subsection{Method \code{all()}}{
Fetches all available items.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeContentCollection$all(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments or query parameters that can be passed to
core \code{api()} function like 'advance_access', 'fields' etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume content collection is requested
vol_con_col_object <- VolumeContentCollection$new(
                    res = x,
                    href = x$href,
                    links = x$links,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get all results
 vol_con_col_object$all()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeContentCollection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeContentCollection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeContentCollection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
