% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-volumes.R
\name{Volumes}
\alias{Volumes}
\title{R6 Class representing volumes endpoints}
\description{
R6 Class representing volumes resource endpoints.
}
\examples{

## ------------------------------------------------
## Method `Volumes$query`
## ------------------------------------------------

\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Query volumes
 volumes_object$query()
}


## ------------------------------------------------
## Method `Volumes$get`
## ------------------------------------------------

\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Get volumes
 volumes_object$get(id = id)
}


## ------------------------------------------------
## Method `Volumes$delete`
## ------------------------------------------------

\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Get volumes
 volumes_object$delete(volume = volume)
}


## ------------------------------------------------
## Method `Volumes$create_s3_using_iam_user`
## ------------------------------------------------

\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Create new AWS Volume (IAM User)
 aws_iam_user_volume <- volumes_object$create_s3_using_iam_user(
    name = "my_new_aws_user_volume",
    bucket = "<bucket-name>",
    description = "AWS IAM User Vol",
    access_key_id = "<access-key>",
    secret_access_key = "<secret-access-key>"
 )
}


## ------------------------------------------------
## Method `Volumes$create_s3_using_iam_role`
## ------------------------------------------------

\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Create new AWS Volume (IAM Role)
 aws_iam_role_volume <- volumes_object$create_s3_using_iam_role(
    name = "my_new_aws_user_volume",
    bucket = "<bucket-name>",
    description = "AWS IAM Role Vol",
    role_arn = "<role-arn-key>",
    external_id = "<external-id>"
 )
}


## ------------------------------------------------
## Method `Volumes$create_google_using_iam_user`
## ------------------------------------------------

\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 #  Create Google cloud volume using IAM User authentication type
 gc_iam_user_volume <- volumes_object$create_google_using_iam_user(
    name = "my_new_gc_user_volume",
    access_mode = "RW",
    bucket = "<bucket-name>",
    description = "GC IAM User volume",
    client_email = "<client_email>",
    private_key = "<private_key-string>"
 )
}


## ------------------------------------------------
## Method `Volumes$create_google_using_iam_role`
## ------------------------------------------------

\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 #  Create Google cloud volume using IAM User authentication type
 gc_iam_role_volume <- volumes_object$create_google_using_iam_role(
    name = "my_new_gc_role_volume",
    access_mode = "RO",
    bucket = "<bucket-name>",
    description = "GC IAM Role volume",
    configuration = list(
        type = "<type-name>",
        audience = "<audience-link>",
        subject_token_type = "<subject_token_type>",
        service_account_impersonation_url = "<service_account_impersonation_url>",
        token_url = "<token_url>",
        credential_source = list(
           environment_id = "<environment_id>",
           region_url = "<region_url>",
           url = "<url>",
           regional_cred_verification_url = "<regional_cred_verification_url>"
         )
   )
 )
}


## ------------------------------------------------
## Method `Volumes$create_azure`
## ------------------------------------------------

\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Create Azure volume
 azure_volume <- volumes_object$create_azure(
   name = "my_new_azure_volume",
   description = "Azure volume",
   endpoint = "<endpoint>",
   container = "<bucket-name",
   storage_account = "<storage_account-name>",
   tenant_id = "<tenant_id>",
   client_id = "<client_id>",
   client_secret = "<client_secret>",
   resource_id = "<resource_id>"
 )
}


## ------------------------------------------------
## Method `Volumes$create_ali_oss`
## ------------------------------------------------

\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Create Ali cloud volume
ali_volume <- volumes_object$create_ali_oss(
  name = "my_new_azure_volume",
  description = "Ali volume",
  endpoint = "<endpoint>",
  bucket = "<bucket-name",
  access_key_id = "<access_key_id>",
  secret_access_key = "<secret_access_key>"
 )
}

}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Volumes}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Volumes-new}{\code{Volumes$new()}}
\item \href{#method-Volumes-query}{\code{Volumes$query()}}
\item \href{#method-Volumes-get}{\code{Volumes$get()}}
\item \href{#method-Volumes-delete}{\code{Volumes$delete()}}
\item \href{#method-Volumes-create_s3_using_iam_user}{\code{Volumes$create_s3_using_iam_user()}}
\item \href{#method-Volumes-create_s3_using_iam_role}{\code{Volumes$create_s3_using_iam_role()}}
\item \href{#method-Volumes-create_google_using_iam_user}{\code{Volumes$create_google_using_iam_user()}}
\item \href{#method-Volumes-create_google_using_iam_role}{\code{Volumes$create_google_using_iam_role()}}
\item \href{#method-Volumes-create_azure}{\code{Volumes$create_azure()}}
\item \href{#method-Volumes-create_ali_oss}{\code{Volumes$create_ali_oss()}}
\item \href{#method-Volumes-clone}{\code{Volumes$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-new"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-new}{}}}
\subsection{Method \code{new()}}{
Create a new Volumes object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-query"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-query}{}}}
\subsection{Method \code{query()}}{
This call lists all the volumes you've registered.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$query(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'limit', 'offset', 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Volume}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Query volumes
 volumes_object$query()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-get"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-get}{}}}
\subsection{Method \code{get()}}{
This call returns details of the specified volume.
The volume is referred to by its ID, which you can obtain by
making the call to list all the volumes you've registered.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$get(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The Volume ID consists of volume owner's name (for enterprise
users) and volume name in form \code{{volume_owner}/{volume_name}},
or division name (if user belongs to some division) and volume
name in form \code{{division}/{volume_name}}. You can also get the Volume ID
for a volume by making the call to list all volumes you've registered.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Volume}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Get volumes
 volumes_object$get(id = id)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-delete}{}}}
\subsection{Method \code{delete()}}{
This call deletes a volume you've created to refer to
storage on Amazon Web Services or Google Cloud Storage. To be able to
delete a volume, you first need to deactivate it and then delete all
files on the Platform that were previously imported from the volume.

Volumes are specified by their IDs, which you can obtain by using
\code{Volumes$query()} to list files or by getting a single file
using \code{Volumes$get()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$delete(volume, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{volume}}{\code{\link{Volume}} object or volume ID.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
as 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Get volumes
 volumes_object$delete(volume = volume)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-create_s3_using_iam_user"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-create_s3_using_iam_user}{}}}
\subsection{Method \code{create_s3_using_iam_user()}}{
Create new volume to connect to your s3 bucket on AWS cloud.
Volumes authorize the Platform to access and query objects on a
specified cloud storage (Amazon Web Services, Google Cloud Storage,
Azure or Ali cloud) on your behalf. This function uses
IAM User credentials to connect to your s3 bucket. \cr \cr

Read more about volume creation in our
\href{https://docs.sevenbridges.com/reference/create-a-volume-v2}{API documentation}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$create_s3_using_iam_user(
  name = NULL,
  access_mode = "RW",
  description = NULL,
  prefix = NULL,
  bucket = NULL,
  endpoint = "s3.amazonaws.com",
  access_key_id = NULL,
  secret_access_key = NULL,
  properties = list(sse_algorithm = "AES256"),
  from_path = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the volume. It must be unique from all
other volumes for this user. Required if from_path parameter
is not provided.}

\item{\code{access_mode}}{Signifies whether this volume should be used
for read-write (RW) or read-only (RO) operations. The access mode is
consulted independently of the credentials granted to Seven Bridges
when the volume was created, so it is possible to use a read-write
credentials to register both read-write and read-only volumes using it.
Default: \code{"RW"}.}

\item{\code{description}}{An optional description of this volume.}

\item{\code{prefix}}{A service-specific string prefix to append to all objects
created in this volume. If the service supports folders, and this prefix
includes them, the API will attempt to create any missing folders
when it outputs a file.}

\item{\code{bucket}}{The name of the AWS S3 bucket you wish to register
as a volume. \cr Required if \code{from_path} parameter is not provided.}

\item{\code{endpoint}}{AWS API endpoint to use when accessing this
bucket. Default: \code{s3.amazonaws.com}.}

\item{\code{access_key_id}}{AWS access key ID in form of string of the IAM user
shared with Seven Bridges to access this bucket.
Required if \code{from_path} parameter is not provided.}

\item{\code{secret_access_key}}{AWS secret access key in form of string of the
IAM user shared with Seven Bridges to access this bucket.
Required if \code{from_path} parameter is not provided.}

\item{\code{properties}}{Named list containing the properties of a specific
service. These values set the defaults for operations performed with
this volume. Individual operations can override these defaults by
providing a custom properties object. For AWS S3, there are:
\itemize{
\item \code{sse_algorithm} - S3 server-side encryption to use when
exporting to this bucket. Supported values:
\code{AES256} (SSE-S3 encryption), \code{aws:kms}, \code{null}
(no server-side encryption). Default: \code{AES256}.
\item \code{sse_aws_kms_key_id}: Applies to type: \code{s3}.
If AWS KMS encryption is used, this should be set to the required
KMS key. If not set and \code{aws:kms} is set as \code{sse_algorithm},
default KMS key is used.
\item \code{aws_canned_acl}: S3 canned ACL to apply on the object
on during export. Supported values: any one of
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl}{S3 canned ACLs};
\code{null} (do not apply canned ACLs). Default: \code{null}.
}}

\item{\code{from_path}}{Path to JSON configuration file containing all
required information for registering a volume. If provided, it will
overwrite all previous parameters set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Volume}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Create new AWS Volume (IAM User)
 aws_iam_user_volume <- volumes_object$create_s3_using_iam_user(
    name = "my_new_aws_user_volume",
    bucket = "<bucket-name>",
    description = "AWS IAM User Vol",
    access_key_id = "<access-key>",
    secret_access_key = "<secret-access-key>"
 )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-create_s3_using_iam_role"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-create_s3_using_iam_role}{}}}
\subsection{Method \code{create_s3_using_iam_role()}}{
Create new volume to connect to your s3 bucket on AWS cloud.
Volumes authorize the Platform to access and query objects on a
specified cloud storage (Amazon Web Services, Google Cloud Storage,
Azure or Ali cloud) on your behalf. This function uses
IAM Role credentials to connect to your s3 bucket.
In order to use these credentials, user must have specific user tag
enabled by Support team. \cr \cr

Read more about volume creation in our
\href{https://docs.sevenbridges.com/reference/create-a-volume-v2}{API documentation}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$create_s3_using_iam_role(
  name = NULL,
  access_mode = "RW",
  description = NULL,
  prefix = NULL,
  bucket = NULL,
  endpoint = "s3.amazonaws.com",
  role_arn = NULL,
  external_id = NULL,
  properties = list(sse_algorithm = "AES256"),
  from_path = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the volume. It must be unique from all
other volumes for this user. Required if from_path parameter
is not provided.}

\item{\code{access_mode}}{Signifies whether this volume should be used
for read-write (RW) or read-only (RO) operations. The access mode is
consulted independently of the credentials granted to Seven Bridges
when the volume was created, so it is possible to use a read-write
credentials to register both read-write and read-only volumes using it.
Default: \code{"RW"}.}

\item{\code{description}}{An optional description of this volume.}

\item{\code{prefix}}{A service-specific string prefix to append to all objects
created in this volume. If the service supports folders, and this prefix
includes them, the API will attempt to create any missing folders
when it outputs a file.}

\item{\code{bucket}}{The name of the AWS S3 bucket you wish to register
as a volume. \cr Required if \code{from_path} parameter is not provided.}

\item{\code{endpoint}}{AWS API endpoint to use when accessing this
bucket. Default: \code{s3.amazonaws.com}.}

\item{\code{role_arn}}{The ARN (Amazon Resource Name) of your role that
is used to connect your S3 bucket.
Required if \code{from_path} parameter is not provided.}

\item{\code{external_id}}{Optional information that you can use in an
IAM role trust policy to designate who can assume the role.
Must be provided if it is configured in your role trust policy on AWS.
Required if \code{from_path} parameter is not provided.}

\item{\code{properties}}{Named list containing the properties of a specific
service. These values set the defaults for operations performed with
this volume. Individual operations can override these defaults by
providing a custom properties object. For AWS S3, there are:
\itemize{
\item \code{sse_algorithm} - S3 server-side encryption to use when
exporting to this bucket. Supported values:
\code{AES256} (SSE-S3 encryption), \code{aws:kms}, \code{null}
(no server-side encryption). Default: \code{AES256}.
\item \code{sse_aws_kms_key_id}: Applies to type: \code{s3}.
If AWS KMS encryption is used, this should be set to the required
KMS key. If not set and \code{aws:kms} is set as \code{sse_algorithm},
default KMS key is used.
\item \code{aws_canned_acl}: S3 canned ACL to apply on the object
on during export. Supported values: any one of
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl}{S3 canned ACLs};
\code{null} (do not apply canned ACLs). Default: \code{null}.
}}

\item{\code{from_path}}{Path to JSON configuration file containing all
required information for registering a volume. If provided, it will
overwrite all previous parameters set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Volume}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Create new AWS Volume (IAM Role)
 aws_iam_role_volume <- volumes_object$create_s3_using_iam_role(
    name = "my_new_aws_user_volume",
    bucket = "<bucket-name>",
    description = "AWS IAM Role Vol",
    role_arn = "<role-arn-key>",
    external_id = "<external-id>"
 )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-create_google_using_iam_user"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-create_google_using_iam_user}{}}}
\subsection{Method \code{create_google_using_iam_user()}}{
Create new volume to connect to your bucket on GCS.
Volumes authorize the Platform to access and query objects on a
specified cloud storage (Amazon Web Services, Google Cloud Storage,
Azure or Ali cloud) on your behalf. This function uses
IAM User credentials to connect with your GCS bucket. \cr \cr
Read more about volume creations in our
\href{https://docs.sevenbridges.com/reference/create-a-volume-v2}{API documentation}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$create_google_using_iam_user(
  name = NULL,
  access_mode = "RW",
  description = NULL,
  prefix = NULL,
  bucket = NULL,
  root_url = "https://www.googleapis.com",
  client_email = NULL,
  private_key = NULL,
  properties = NULL,
  from_path = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the volume. It must be unique from all
other volumes for this user. Required if \code{from_path} parameter
is not provided.}

\item{\code{access_mode}}{Signifies whether this volume should be used
for read-write (RW) or read-only (RO) operations. The access mode is
consulted independently of the credentials granted to Seven Bridges
when the volume was created, so it is possible to use a read-write
credentials to register both read-write and read-only volumes using it.
Default: \code{"RW"}.}

\item{\code{description}}{An optional description of this volume.}

\item{\code{prefix}}{A service-specific string prefix to append to all objects
created in this volume. If the service supports folders, and this prefix
includes them, the API will attempt to create any missing folders
when it outputs a file.}

\item{\code{bucket}}{The name of the GCS bucket you wish to register
as a volume. Required if \code{from_path} parameter is not provided.}

\item{\code{root_url}}{Google Cloud Storage API endpoint for accessing
this bucket. \cr Default: \verb{https://www.googleapis.com}.}

\item{\code{client_email}}{The client email address for the Google Cloud
service account to use for operations on this bucket. This can be found
in the JSON containing your service account credentials.
Required if \code{from_path} parameter is not provided.}

\item{\code{private_key}}{Google Cloud Platform private key.
Required if \code{from_path} parameter is not provided.}

\item{\code{properties}}{Named list containing the properties of a specific
service. These values set the defaults for operations performed with
this volume. Individual operations can override these defaults by
providing a custom properties object.}

\item{\code{from_path}}{Path to JSON configuration file containing all
required information for registering a volume. If provided, it will
overwrite all previous parameters set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Volume}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 #  Create Google cloud volume using IAM User authentication type
 gc_iam_user_volume <- volumes_object$create_google_using_iam_user(
    name = "my_new_gc_user_volume",
    access_mode = "RW",
    bucket = "<bucket-name>",
    description = "GC IAM User volume",
    client_email = "<client_email>",
    private_key = "<private_key-string>"
 )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-create_google_using_iam_role"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-create_google_using_iam_role}{}}}
\subsection{Method \code{create_google_using_iam_role()}}{
Create new volume to connect to your bucket on GCS.
Volumes authorize the Platform to access and query objects on a
specified cloud storage (Amazon Web Services, Google Cloud Storage,
Azure or Ali cloud) on your behalf. This function uses
IAM Role credentials to connect to your GCS bucket.
In order to use these credentials, user must have specific user tag
enabled by Support team. \cr \cr
Read more about volume creations in our
\href{https://docs.sevenbridges.com/reference/create-a-volume-v2}{API documentation}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$create_google_using_iam_role(
  name = NULL,
  access_mode = "RW",
  description = NULL,
  prefix = NULL,
  bucket = NULL,
  root_url = "https://www.googleapis.com",
  configuration = NULL,
  properties = NULL,
  from_path = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the volume. It must be unique from all
other volumes for this user. Required if from_path parameter
is not provided.}

\item{\code{access_mode}}{Signifies whether this volume should be used
for read-write (RW) or read-only (RO) operations. The access mode is
consulted independently of the credentials granted to Seven Bridges
when the volume was created, so it is possible to use a read-write
credentials to register both read-write and read-only volumes using it.
Default: \code{"RW"}.}

\item{\code{description}}{An optional description of this volume.}

\item{\code{prefix}}{A service-specific string prefix to append to all objects
created in this volume. If the service supports folders, and this prefix
includes them, the API will attempt to create any missing folders
when it outputs a file.}

\item{\code{bucket}}{The name of the GCS bucket you wish to register
as a volume. Required if \code{from_path} parameter is not provided.}

\item{\code{root_url}}{Google Cloud Storage API endpoint for accessing
this bucket. \cr Default: \verb{https://www.googleapis.com}.}

\item{\code{configuration}}{Connection configuration parameters in JSON format
downloaded from the Google Cloud Console once prerequisites have been
set up. Could be provided as a named list, or as path to the downloaded
JSON file.}

\item{\code{properties}}{Named list containing the properties of a specific
service. These values set the defaults for operations performed with
this volume. Individual operations can override these defaults by
providing a custom properties object.}

\item{\code{from_path}}{Path to JSON configuration file containing all
required information for registering a volume. If provided, it will
overwrite all previous parameters set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Volume}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 #  Create Google cloud volume using IAM User authentication type
 gc_iam_role_volume <- volumes_object$create_google_using_iam_role(
    name = "my_new_gc_role_volume",
    access_mode = "RO",
    bucket = "<bucket-name>",
    description = "GC IAM Role volume",
    configuration = list(
        type = "<type-name>",
        audience = "<audience-link>",
        subject_token_type = "<subject_token_type>",
        service_account_impersonation_url = "<service_account_impersonation_url>",
        token_url = "<token_url>",
        credential_source = list(
           environment_id = "<environment_id>",
           region_url = "<region_url>",
           url = "<url>",
           regional_cred_verification_url = "<regional_cred_verification_url>"
         )
   )
 )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-create_azure"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-create_azure}{}}}
\subsection{Method \code{create_azure()}}{
This call creates a new volume by attaching a Microsoft
Azure storage container to the Platform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$create_azure(
  name = NULL,
  description = NULL,
  endpoint = NULL,
  storage_account = NULL,
  container = NULL,
  prefix = NULL,
  tenant_id = NULL,
  client_id = NULL,
  client_secret = NULL,
  resource_id = NULL,
  from_path = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the volume. It must be unique from all
other volumes for this user. Required if \code{from_path} parameter
is not provided.}

\item{\code{description}}{An optional description of this volume.}

\item{\code{endpoint}}{Specify a Microsoft Azure endpoint, only if you
are using an endpoint that is different from the default one
\verb{https://(serviceaccount).blob.core.windows.net}. To make a non-default
endpoint work with the Platform, please first make sure it is supported
by Seven Bridges.}

\item{\code{storage_account}}{The name of the storage account that holds the
container you want to attach as a volume.}

\item{\code{container}}{The name of the container that you want to attach as
a Volume.}

\item{\code{prefix}}{A service-specific string prefix to append to all objects
created in this volume. If the service supports folders, and this prefix
includes them, the API will attempt to create any missing folders
when it outputs a file.}

\item{\code{tenant_id}}{Directory (tenant) ID of the application you created
on the Azure Portal for the purpose of attaching your storage container.}

\item{\code{client_id}}{Application (client) ID of the application you
created on the Azure Portal for the purpose of attaching your storage
container.}

\item{\code{client_secret}}{Value of the client secret you created on the Azure
Portal for the purpose of attaching your storage container.}

\item{\code{resource_id}}{Resource ID of the Azure storage account. To get it,
go to the \href{https://portal.azure.com/}{Azure Portal}, open the storage
account's Overview page and click JSON View.}

\item{\code{from_path}}{JSON configuration file containing all required
information for registering a volume.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Volume}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Create Azure volume
 azure_volume <- volumes_object$create_azure(
   name = "my_new_azure_volume",
   description = "Azure volume",
   endpoint = "<endpoint>",
   container = "<bucket-name",
   storage_account = "<storage_account-name>",
   tenant_id = "<tenant_id>",
   client_id = "<client_id>",
   client_secret = "<client_secret>",
   resource_id = "<resource_id>"
 )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-create_ali_oss"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-create_ali_oss}{}}}
\subsection{Method \code{create_ali_oss()}}{
Create new volume to connect to your bucket on ALI (OSS)
platform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$create_ali_oss(
  name = NULL,
  description = NULL,
  endpoint = NULL,
  bucket = NULL,
  prefix = NULL,
  access_key_id = NULL,
  secret_access_key = NULL,
  properties = NULL,
  from_path = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the volume. It must be unique from all
other volumes for this user. Required if from_path parameter
is not provided.}

\item{\code{description}}{An optional description of this volume.}

\item{\code{endpoint}}{Specify an Ali Cloud endpoint.}

\item{\code{bucket}}{The name of the ALI(OSS) bucket you wish to register
as a volume. Required if \code{from_path} parameter is not provided.}

\item{\code{prefix}}{A service-specific string prefix to append to all objects
created in this volume. If the service supports folders, and this
prefix includes them, the API will attempt to create any missing folders
when it outputs a file.}

\item{\code{access_key_id}}{ALI(OSS) access key ID of the user shared
with Seven Bridges to access this bucket.
Required if \code{from_path} parameter is not provided.}

\item{\code{secret_access_key}}{ALI(OSS) secret access key of the user
shared with Seven Bridges to access this bucket.
Required if \code{from_path} parameter is not provided.}

\item{\code{properties}}{Named list containing the properties of a specific
service. These values set the defaults for operations performed with
this volume. Individual operations can override these defaults by
providing a custom properties object.}

\item{\code{from_path}}{JSON configuration file containing all required
information for registering a volume.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Volume}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 volumes_object <- Volumes$new(auth = auth)

 # Create Ali cloud volume
ali_volume <- volumes_object$create_ali_oss(
  name = "my_new_azure_volume",
  description = "Ali volume",
  endpoint = "<endpoint>",
  bucket = "<bucket-name",
  access_key_id = "<access_key_id>",
  secret_access_key = "<secret_access_key>"
 )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volumes-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Volumes-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volumes$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
