% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkb.R
\name{st_as_binary}
\alias{st_as_binary}
\alias{st_as_binary}
\alias{st_as_binary.sfc}
\alias{st_as_binary}
\alias{st_as_binary.sfg}
\title{Convert sfc object to an WKB object}
\usage{
st_as_binary(x, ...)

\method{st_as_binary}{sfc}(x, ..., EWKB = FALSE, endian = .Platform$endian,
  pureR = FALSE, precision = attr(x, "precision"), hex = FALSE)

\method{st_as_binary}{sfg}(x, ..., endian = .Platform$endian, EWKB = FALSE,
  pureR = FALSE, hex = FALSE)
}
\arguments{
\item{x}{object to convert}

\item{...}{ignored}

\item{EWKB}{logical; use EWKB (PostGIS), or (default) ISO-WKB?}

\item{endian}{character; either "big" or "little"; default: use that of platform}

\item{pureR}{logical; use pure R solution, or C++?}

\item{precision}{numeric; if zero, do not modify; to reduce precision: negative values convert to float (4-byte real); positive values convert to round(x*precision)/precision. See details.}

\item{hex}{logical; return hexadecimal encoded (character)?}
}
\description{
Convert sfc object to an WKB object
}
\details{
for the precion model, see also \url{http://tsusiatsoftware.net/jts/javadoc/com/vividsolutions/jts/geom/PrecisionModel.html}. There, it is written that: ``... to specify 3 decimal places of precision, use a scale factor of 1000. To specify -3 decimal places of precision (i.e. rounding to the nearest 1000), use a scale factor of 0.001.''. Note that ALL coordinates, so also Z or M values (if present) are affected.
}
