context("st_bbox")

test_that("st_bbox", {
  p1 = st_point(1:3)
  bb = st_bbox(p1)
  expect_true(all(st_bbox(p1) == c(1,2,1,2)))
  expect_true(all(names(st_bbox(p1)) == c("xmin","ymin","xmax","ymax")))
  x = st_geometrycollection(list(st_point(1:2),st_linestring(matrix(1:4,2))))
  expect_true(all(st_bbox(x) == c(1,2,2,4)))
  expect_true(all(names(st_bbox(x)) == c("xmin","ymin","xmax","ymax")))
  x = st_sf(a = 1, geom = st_sfc(x))
  expect_true(all(st_bbox(x) == c(1,2,2,4)))
})
