% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_sfg.R, R/cast_sfc.R
\name{st_cast}
\alias{st_cast}
\alias{st_cast.MULTIPOLYGON}
\alias{st_cast}
\alias{st_cast.MULTILINESTRING}
\alias{st_cast}
\alias{st_cast.MULTIPOINT}
\alias{st_cast}
\alias{st_cast.POLYGON}
\alias{st_cast}
\alias{st_cast.LINESTRING}
\alias{st_cast}
\alias{st_cast.POINT}
\alias{st_cast}
\alias{st_cast.GEOMETRYCOLLECTION}
\alias{st_cast}
\alias{st_cast.CIRCULARSTRING}
\alias{st_cast}
\alias{st_cast.MULTISURFACE}
\alias{st_cast}
\alias{st_cast.COMPOUNDCURVE}
\alias{st_cast}
\alias{st_cast.CURVE}
\alias{st_cast}
\alias{st_cast}
\alias{st_cast.sfc}
\alias{st_cast}
\alias{st_cast.sf}
\alias{st_cast}
\alias{st_cast.sfc_CIRCULARSTRING}
\title{Cast geometry to another type: either simplify, or cast explicitly}
\usage{
\method{st_cast}{MULTIPOLYGON}(x, to, ...)

\method{st_cast}{MULTILINESTRING}(x, to, ...)

\method{st_cast}{MULTIPOINT}(x, to, ...)

\method{st_cast}{POLYGON}(x, to, ...)

\method{st_cast}{LINESTRING}(x, to, ...)

\method{st_cast}{POINT}(x, to, ...)

\method{st_cast}{GEOMETRYCOLLECTION}(x, to, ...)

\method{st_cast}{CIRCULARSTRING}(x, to, ...)

\method{st_cast}{MULTISURFACE}(x, to, ...)

\method{st_cast}{COMPOUNDCURVE}(x, to, ...)

\method{st_cast}{CURVE}(x, to, ...)

st_cast(x, to, ...)

\method{st_cast}{sfc}(x, to, ..., ids = seq_along(x), group_or_split = TRUE)

\method{st_cast}{sf}(x, to, ..., warn = TRUE, do_split = TRUE)

\method{st_cast}{sfc_CIRCULARSTRING}(x, to, ...)
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfc} or \code{sf}}

\item{to}{character; target type, if missing, simplification is tried; when \code{x} is of type \code{sfg} (i.e., a single geometry) then \code{to} needs to be specified.}

\item{...}{ignored}

\item{ids}{integer vector, denoting how geometries should be grouped (default: no grouping)}

\item{group_or_split}{logical; if TRUE, group or split geometries; if FALSE, carry out a 1-1 per-geometry conversion.}

\item{warn}{logical; if \code{TRUE}, warn if attributes are assigned to sub-geometries}

\item{do_split}{logical; if \code{TRUE}, allow splitting of geometries in sub-geometries}
}
\value{
object of class \code{to} if successful, or unmodified object if unsuccessful. If information gets lost while type casting, a warning is raised.

In case \code{to} is missing, \code{st_cast.sfc} will coerce combinations of "POINT" and "MULTIPOINT", "LINESTRING" and "MULTILINESTRING", "POLYGON" and "MULTIPOLYGON" into their "MULTI..." form, or in case all geometries are "GEOMETRYCOLLECTION" will return a list of all the contents of the "GEOMETRYCOLLECTION" objects, or else do nothing. In case \code{to} is specified, if \code{to} is "GEOMETRY", geometries are not converted, else, \code{st_cast} will try to coerce all elements into \code{to}; \code{ids} may be specified to group e.g. "POINT" objects into a "MULTIPOINT", if not specified no grouping takes place. If e.g. a "sfc_MULTIPOINT" is cast to a "sfc_POINT", the objects are split, so no information gets lost, unless \code{group_or_split} is \code{FALSE}.
}
\description{
Cast geometry to another type: either simplify, or cast explicitly
}
\details{
the \code{st_cast} method for \code{sf} objects can only split geometries, e.g. cast \code{MULTIPOINT} into multiple \code{POINT} features.  In case of splitting, attributes are repeated and a warning is issued when non-constant attributes are assigned to sub-geometries. To merge feature geometries and attribute values, use \link[sf]{aggregate} or \link[sf]{summarise}.
}
\examples{
example(st_read)
mpl <- nc$geometry[[4]]
#st_cast(x) ## error 'argument "to" is missing, with no default'
cast_all <- function(xg) {
  lapply(c("MULTIPOLYGON", "MULTILINESTRING", "MULTIPOINT", "POLYGON", "LINESTRING", "POINT"), 
      function(x) st_cast(xg, x))
}
st_sfc(cast_all(mpl))
## no closing coordinates should remain for multipoint
any(duplicated(unclass(st_cast(mpl, "MULTIPOINT"))))  ## should be FALSE
## number of duplicated coordinates in the linestrings should equal the number of polygon rings 
## (... in this case, won't always be true)
sum(duplicated(do.call(rbind, unclass(st_cast(mpl, "MULTILINESTRING"))))
     ) == sum(unlist(lapply(mpl, length)))  ## should be TRUE

p1 <- structure(c(0, 1, 3, 2, 1, 0, 0, 0, 2, 4, 4, 0), .Dim = c(6L, 2L))
p2 <- structure(c(1, 1, 2, 1, 1, 2, 2, 1), .Dim = c(4L, 2L))
st_polygon(list(p1, p2))
mls <- st_cast(nc$geometry[[4]], "MULTILINESTRING")
st_sfc(cast_all(mls))
mpt <- st_cast(nc$geometry[[4]], "MULTIPOINT")
st_sfc(cast_all(mpt))
pl <- st_cast(nc$geometry[[4]], "POLYGON")
st_sfc(cast_all(pl))
ls <- st_cast(nc$geometry[[4]], "LINESTRING")
st_sfc(cast_all(ls))
pt <- st_cast(nc$geometry[[4]], "POINT")
## st_sfc(cast_all(pt))  ## Error: cannot create MULTIPOLYGON from POINT 
st_sfc(lapply(c("POINT", "MULTIPOINT"), function(x) st_cast(pt, x)))
s = st_multipoint(rbind(c(1,0)))
st_cast(s, "POINT")
}
