% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp.R
\name{as}
\alias{as}
\alias{coerce,Spatial,sf-method}
\alias{as}
\alias{coerce,Spatial,sfc-method}
\alias{as}
\alias{coerce,sf,Spatial-method}
\alias{as}
\alias{coerce,sfc,Spatial-method}
\alias{as_Spatial}
\title{Methods to coerce simple feature geometries to corresponding \code{Spatial*} objects}
\usage{
as_Spatial(from, cast = TRUE, IDs = paste0("ID", 1:length(from)))
}
\arguments{
\item{from}{object of class \code{sfc_POINT}, \code{sfc_MULTIPOINT}, \code{sfc_LINESTRING}, \code{sfc_MULTILINESTRING}, \code{sfc_POLYGON}, or \code{sfc_MULTIPOLYGON}.}

\item{cast}{logical; if \code{TRUE}, \link{st_cast} \code{from} before converting, so that e.g. \code{GEOMETRY} objects with a mix of \code{POLYGON} and \code{MULTIPOLYGON} are cast to \code{MULTIPOLYGON}.}

\item{IDs}{character vector with IDs for the \code{Spatial*} geometries}
}
\value{
geometry-only object deriving from \code{Spatial}, of the appropriate class
}
\description{
Methods to coerce simple feature geometries to corresponding \code{Spatial*} objects
}
\examples{
nc = st_read(system.file("shape/nc.shp", package="sf"))
as_Spatial(st_geometry(nc[1,]))
}
