% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp.fit.airwls}
\alias{cpp.fit.airwls}
\title{Fit a GMF model using the AIRWLS algorithm}
\usage{
cpp.fit.airwls(
  Y,
  X,
  B,
  A,
  Z,
  U,
  V,
  O,
  W,
  familyname,
  linkname,
  varfname,
  ncomp,
  lambda,
  maxiter = 500L,
  nsteps = 1L,
  stepsize = 0.1,
  eps = 1e-08,
  nafill = 1L,
  tol = 1e-05,
  damping = 0.001,
  verbose = TRUE,
  frequency = 10L,
  parallel = FALSE,
  nthreads = 1L
)
}
\arguments{
\item{Y}{matrix of responses (\eqn{n \times m})}

\item{X}{matrix of row fixed effects (\eqn{n \times p})}

\item{B}{initial row-effect matrix (\eqn{n \times p})}

\item{A}{initial column-effect matrix (\eqn{n \times q})}

\item{Z}{matrix of column fixed effects (\eqn{m \times q})}

\item{U}{initial factor matrix (\eqn{n \times d})}

\item{V}{initial loading matrix (\eqn{m \times d})}

\item{O}{matrix of constant offset (\eqn{n \times m})}

\item{W}{matrix of constant weights (\eqn{n \times m})}

\item{familyname}{a \code{glm} model family name}

\item{linkname}{a \code{glm} link function name}

\item{varfname}{variance function name}

\item{ncomp}{rank of the latent matrix factorization}

\item{lambda}{penalization parameters}

\item{maxiter}{maximum number of iterations}

\item{nsteps}{number of inner Fisher scoring iterations}

\item{stepsize}{stepsize of the inner Fisher scoring algorithm}

\item{eps}{shrinkage factor for extreme predictions}

\item{nafill}{how often the missing values are updated}

\item{tol}{tolerance threshold for the stopping criterion}

\item{damping}{diagonal dumping factor for the Hessian matrix}

\item{verbose}{if \code{TRUE}, print the optimization status}

\item{frequency}{how often the optimization status is printed}

\item{parallel}{if \code{TRUE}, allows for parallel computing}

\item{nthreads}{number of cores to be used in parallel}
}
\description{
Fit a GMF model using the AIRWLS algorithm
}
\keyword{internal}
