% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_parameters.R
\name{smoothp}
\alias{smoothp}
\title{smoothp}
\usage{
smoothp(formula, npc, data, method = "PAIC", basis, interval, step)
}
\arguments{
\item{formula}{a symbolic description of the systematic component of the model to be fitted.}

\item{npc}{a data frame with potential nonparametric variables of the systematic part of the model to be fitted.}

\item{data}{a data frame which contains the variables in the model.}

\item{method}{There are three possible criteria to estimate the smoothing parameters: Penalized Akaike Criterion 'PAIC', Penalized Bayesian Criterion 'PBIC' and
Generalized Cross Validation 'GCV'. The default method is 'PAIC'.}

\item{basis}{a name of the cubic spline basis to be used in the model. Supported basis include deBoor and Gu basis.}

\item{interval}{an optional numerical vector of length 2. In this interval is the maximum likelihood estimate of the shape parameter of the model.
By default is [0.1,2].}

\item{step}{an optional positive value. This parameter represents the length of the step of the partition of the interval parameter.
By default is 0.2.}
}
\description{
Tool that supports the selection of the smoothing parameters in semi-parametric generalized log-gamma models.
The selection is based on the AIC, BIC, or Generalized Cross Validation methods.
}
\examples{
set.seed(1)
rows<- 150
t_beta <- c(0.5,2)
t_sigma <- 0.5
t_lambda <- 1
x1 <- runif(rows,-3,3)
x2 <- rbinom(rows,1,0.5)
X <- cbind(x1,x2)
t <- as.matrix((2*1:rows - 1)/(2*rows))
colnames(t) <- "t"
f_t <- cos(4*pi*t)
error <- rglg(rows,0,1,t_lambda)
y <- X \%*\%t_beta + f_t + t_sigma*error
colnames(y) <- "y"
data <- data.frame(y,X,t)
fit1 <- sglg(y ~ x1 + x2 - 1,npc=t,data=data,basis = "deBoor",alpha0=1)
fit1$AIC
# We can get (probably) better values of alpha with the function smoothp
smoothp(y ~ x1 + x2 - 1,npc=t,data=data,basis = "deBoor")
fit2 <- sglg(y ~ x1 + x2 - 1,npc=t,data=data,basis = "Gu",alpha0=0.5)
fit2$BIC
# Again using the smooth function
smoothp(y ~ x1 + x2 - 1,npc=t,data=data,basis = "Gu",method='PBIC')
#################################################
# An example with two non-parametric components #
#################################################
set.seed(2)
t_2 <- as.matrix(rnorm(rows,sd=0.5))
colnames(t_2) <- 't_2'
f_t_2 <- exp(t_2)
error <- rglg(rows,0,1,t_lambda)
y_2 <- X \%*\%t_beta + f_t + f_t_2 + t_sigma*error
colnames(y_2) <- 'y_2'
data2 <- data.frame(y_2,X,t,t_2)
npcs <- cbind(t,t_2)
# Some intuition about the best alpha values
smoothp(y ~ x1 + x2 - 1,npc=npcs,data=data, method='GCV')
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph.D. thesis. Sao Paulo University.

Cardozo C.A.,  Paula G., and Vanegas L. (2022). Generalized log-gamma additive partial linear models with P-spline smoothing. Statistical Papers.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
