% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_quantiles.R
\name{strat_quantiles}
\alias{strat_quantiles}
\title{Quantiles stratification}
\usage{
strat_quantiles(
  mraster,
  mraster2 = NULL,
  nStrata,
  nStrata2 = NULL,
  plot = FALSE,
  details = FALSE,
  samp = 0.2,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{mraster}{spatRaster. ALS metrics raster.}

\item{mraster2}{Spatraster. Secondary covariate raster to stratify.}

\item{nStrata}{Numeric. Number of quantiles to stratify \code{mraster}.}

\item{nStrata2}{Numeric. Number of quantiles to stratify \code{mraster2}.}

\item{plot}{Logical. Plots output strata raster and visualized
strata with boundary dividers.}

\item{details}{Logical. If \code{FALSE} (default) output is only
stratification raster. If \code{TRUE} return a list where \code{$details} is additional 
stratification information and \code{$raster} is the output stratification spatRaster.}

\item{samp}{Numeric. Determines proportion of cells to plot in scatterplot (default = \code{0.2}).
Lower values reduce visualization time.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}
}
\value{
Returns an output stratification \code{spatRaster} or a list when \code{details = TRUE}.

When a list is returned:
\enumerate{
\item \code{details} generates is a strata lookUp table for the stratification.
\item \code{raster} is a stratified \code{spatRaster} based on quantiles
\item \code{plot} is a \code{ggplot} histogram / scatter plot object (depends on whether metric2 was supplied).
Histogram shows distribution and break points while scatter plot shows colour coded and strata boundaries.
}
}
\description{
Stratify metric raster using metric quantiles.
}
\examples{
#--- Load raster and existing plots---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

strat_quantiles(
  mraster = mr$zq90,
  nStrata = 4,
  plot = TRUE
)

strat_quantiles(
  mraster = mr$zq90,
  mraster2 = mr$zsd,
  nStrata = 3,
  nStrata2 = 4
)
}
\seealso{
Other stratify functions: 
\code{\link{strat_breaks}()},
\code{\link{strat_kmeans}()},
\code{\link{strat_map}()},
\code{\link{strat_poly}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{stratify functions}
