% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.mass.R
\name{partition.confidence}
\alias{partition.confidence}
\title{Partition Confidence}
\usage{
partition.confidence(x, y)
}
\arguments{
\item{x}{If \code{y} is not specified then \code{x} must be an object of
class \code{sdols.confidence}. Otherwise, \code{x} is a vector of cluster
labels and \code{y} is an expected pairwise allocation matrix.}

\item{y}{If \code{y} is not specified then \code{x} must be an object of
class \code{sdols.confidence}. Otherwise, \code{x} is a vector of cluster
labels and \code{y} is an expected pairwise allocation matrix.}
}
\description{
This function calculates the partition confidence of a partition estimate
from the corresponding expected pairwise allocation matrix (EPAM).
}
\details{
The \code{\link{partition.confidence}} takes as input an object of class
\code{sdols.confidence} and then calculates the partition confidence from the
expected pairwise allocation matrix.

The partition confidence is the average values of the EPAM for items that are
clustered together. Items which are in their own subset do not contribute to
partition confidence.
}
\examples{
x <- rep(c(1,2,3), times=c(2,3,5))
y <- diag(10)
y[upper.tri(y)] <- runif(45)
partition.confidence(x,y)

}
\seealso{
Other Default Mass Selection: \code{\link{default.mass}},
  \code{\link{mass.algorithm}},
  \code{\link{variance.ratio}}
}
\concept{Default Mass Selection}
