% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shallot.R
\name{sample.partitions}
\alias{sample.partitions}
\alias{print.shallot.samples.raw}
\title{Sample Partitions from Partition Distributions}
\usage{
sample.partitions(x, n.draws, parallel = TRUE)
}
\arguments{
\item{x}{An object of class \code{shallot.distribution} obtained, for
example, from the \code{\link{ewens.pitman.attraction}} function.}

\item{n.draws}{An integer representing the desired number of samples.  Due
to parallelization, slightly more samples may be returned.}

\item{parallel}{Should sampling be done in parallel by simultaneously using
all CPU cores?}
}
\value{
An object of class \code{shallot.samples.raw} which can be
subsequently be used in \code{\link{process.samples}},
\code{\link{pairwise.probabilities}}, \code{\link{estimate.partition}},
}
\description{
This function samples partitions from the Ewens, Ewens-Pitman, Ewens
attraction, Ewens-Pitman attraction, and ddCRP distributions.
}
\note{
If this function is interrupted by the user, the computation engine
will be broken and subsequent calls to package functions may fail until a
new session is started.
}
\examples{

\dontrun{
example(shallot)
}

}
\seealso{
\code{\link{partition.distribution}},
\code{\link{process.samples}}, \code{\link{pairwise.probabilities}},
\code{\link{estimate.partition}}
}
\author{
David B. Dahl \email{dahl@stat.byu.edu}
}
