% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_importance.R
\name{sv_importance}
\alias{sv_importance}
\alias{sv_importance.default}
\alias{sv_importance.shapviz}
\title{SHAP Importance Plots}
\usage{
sv_importance(object, ...)

\method{sv_importance}{default}(object, ...)

\method{sv_importance}{shapviz}(
  object,
  kind = c("beeswarm", "bar", "both", "no"),
  max_display = 10L,
  fill = "#fca50a",
  format_fun = function(z) prettyNum(z, digits = 3, scientific = FALSE),
  number_size = 3.2,
  ...
)
}
\arguments{
\item{object}{An object of class "shapviz".}

\item{...}{Arguments passed to \code{geom_bar()} (if \code{kind = "bar"}) or
to \code{ggbeeswarm::geom_quasirandom()} otherwise.
For instance, passing \code{alpha = 0.2} will produce semi-transparent beeswarms,
setting \code{size = 3} will produce larger dots, or \code{width = 0.2} will
produce less wide swarms.}

\item{kind}{Should a "beeswarm" plot (the default), a "bar" plot or "both" be shown?
Set to "no" in order to suppress plotting. In that case, the sorted
average absolute SHAP values of all variables are returned.}

\item{max_display}{Maximum number of features (with largest mean absolute SHAP value)
should be plotted? If there are more, the most unimportant variables are collapsed:
their SHAP values are added and their min-max-scaled feature values are added as
well (and the resulting vector is min-max-scaled again). Set to \code{Inf} to show
all features.}

\item{fill}{Color used to fill the bars (only used if \code{kind = "bar"}).}

\item{format_fun}{Function used to format mean absolute SHAP values shown on the
bar plot. Use \code{format_fun = function(z) = ""} to suppress printing.}

\item{number_size}{Text size of the formatted numbers (only if \code{kind = "bar"}).}
}
\value{
A \code{ggplot} object representing an importance plot or - if \code{kind = "no"} a named numeric vector of mean absolute SHAP values sorted in decreasing order.
}
\description{
This function provides two types of SHAP importance plots: a beeswarm plot (the default)
and a bar plot. The beeswarm plot displays SHAP values per feature, using min-max
scaled feature values on the color scale (non-numeric features are transformed
to numeric by calling \code{data.matrix()} first).
The bar plot shows average absolute SHAP values. Both types can be combined.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method.

\item \code{shapviz}: SHAP importance plot for an object of class "shapviz".
}}

\examples{
X_train <- data.matrix(iris[, -1])
dtrain <- xgboost::xgb.DMatrix(X_train, label = iris[, 1])
fit <- xgboost::xgb.train(data = dtrain, nrounds = 50)
x <- shapviz(fit, X_pred = X_train)
sv_importance(x)
sv_importance(x, kind = "bar")
sv_importance(x, kind = "both")
sv_importance(x, kind = "no")
}
