% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{SelectionProportions}
\alias{SelectionProportions}
\title{Selection proportions}
\usage{
SelectionProportions(stability, argmax_id = NULL)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}},
\code{\link{GraphicalModel}}, or \code{\link{BiSelection}}.}

\item{argmax_id}{optional matrix of parameter IDs. If \code{argmax_id=NULL},
the calibrated model is used.}
}
\value{
A symmetric matrix (graphical model) or vector (variable selection)
  of selection proportions.
}
\description{
Extracts the selection (or co-membership) proportions of the (calibrated)
model.
}
\examples{
\donttest{
## Variable selection

# Data simulation
set.seed(1)
simul <- SimulateRegression(pk = 50)

# Stability selection
stab <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata)

# Calibrated selection proportions
prop <- SelectionProportions(stab)

# User-defined parameters
myids <- matrix(c(80, 10), nrow = 1)
stab$Lambda[myids[1], 1] # corresponding penalty
stab$params$pi_list[myids[2]] # corresponding threshold
prop <- SelectionProportions(stab, argmax_id = myids)


## Graphical model

# Data simulation
set.seed(1)
simul <- SimulateGraphical(pk = 20)

# Stability selection
stab <- GraphicalModel(xdata = simul$data)

# Calibrated matrix of selection proportions
prop <- SelectionProportions(stab)

# User-defined parameters
myids <- matrix(c(20, 10), nrow = 1)
stab$Lambda[myids[1], 1] # corresponding penalty
stab$params$pi_list[myids[2]] # corresponding threshold
prop <- SelectionProportions(stab, argmax_id = myids)


## Dimensionality reduction

# Data simulation (continuous outcomes)
set.seed(1)
simul <- SimulateRegression(n = 50, pk = c(5, 5, 5), family = "gaussian")
x <- simul$xdata
y <- simul$ydata

# Sparse PLS
stab <- BiSelection(
  xdata = x, ydata = y,
  family = "gaussian", ncomp = 3,
  LambdaX = 1:(ncol(x) - 1),
  implementation = SparsePLS
)

# Calibrated selection proportions per component
prop <- SelectionProportions(stab)
}

}
\seealso{
\code{\link{VariableSelection}}, \code{\link{GraphicalModel}},
  \code{\link{BiSelection}}

Other calibration functions: 
\code{\link{Adjacency}()},
\code{\link{ArgmaxId}()},
\code{\link{Argmax}()},
\code{\link{CalibrationPlot}()},
\code{\link{SelectedVariables}()}
}
\concept{calibration functions}
