% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_score.R
\name{StabilityScore}
\alias{StabilityScore}
\title{Stability score}
\usage{
StabilityScore(
  selprop,
  pi_list = seq(0.6, 0.9, by = 0.01),
  K,
  n_cat = 3,
  group = NULL
)
}
\arguments{
\item{selprop}{array of selection proportions.}

\item{pi_list}{vector of thresholds in selection proportions. If
\code{n_cat=3}, these values must be \code{>0.5} and \code{<1}. If
\code{n_cat=2}, these values must be \code{>0} and \code{<1}.}

\item{K}{number of resampling iterations.}

\item{n_cat}{number of categories used to compute the stability score.
Possible values are 2 or 3.}

\item{group}{vector encoding the grouping structure among predictors. This
argument indicates the number of variables in each group and only needs to
be provided for group (but not sparse group) penalisation.}
}
\value{
A vector of stability scores obtained with the different thresholds
  in selection proportions.
}
\description{
Computes the stability score from selection proportions of models with a
given parameter controlling the sparsity and for different thresholds in
selection proportions. The score measures how unlikely it is that the
selection procedure is uniform (i.e. uninformative) for a given combination
of parameters.
}
\details{
The stability score is derived from the likelihood under the
  assumption of uniform (uninformative) selection.

  We classify the features into three categories: the stably selected ones
  (that have selection proportions \eqn{\ge \pi}), the stably excluded ones
  (selection proportion \eqn{\le 1-\pi}), and the unstable ones (selection
  proportions between \eqn{1-\pi} and \eqn{\pi}).

  The likelihood of observing stably selected, stably excluded and unstable
  features can be expressed as:

  \eqn{L_{\lambda, \pi} = \prod_{j=1}^N [ P( H_{\lambda} (j) \geq K
  \pi)^{1_{H_{\lambda} (j) \ge K \pi}} \times P( (1-\pi) K < H_{\lambda} (j)
  < K \pi )^{1_{ (1-\pi) K < H_{\lambda} (j) < K \pi }} \times P( H_{\lambda}
  (j) \leq K (1-\pi) )^{1_{ H_{\lambda} (j) \le K (1-\pi) }} ]}

  where \eqn{H_{\lambda} (j)} is the selection count of feature \eqn{j}.

  The stability score is computed as the minus log-transformed likelihood
  under the assumption of uniform selection:

  \eqn{S_{\lambda, \pi} = -log(L_{\lambda, \pi})}

  Alternatively, the stability score can be computed by considering only two
  sets of features: stably selected (selection proportions \eqn{\ge \pi}) or
  not (selection proportions \eqn{< \pi}). This can be done using
  \code{n_cat=2}.
}
\examples{
# Simulating set of selection proportions
set.seed(1)
selprop <- round(runif(n = 20), digits = 2)

# Computing stability scores for different thresholds
score <- StabilityScore(selprop, pi_list = c(0.6, 0.7, 0.8), K = 100)
}
\references{
\insertRef{ourstabilityselection}{sharp}
}
\seealso{
Other stability metric functions: 
\code{\link{FDP}()},
\code{\link{PFER}()},
\code{\link{StabilityMetrics}()}
}
\concept{stability metric functions}
