% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeR0bar}
\alias{computeR0bar}
\title{Computes the average difference between the number of upper and lower records of the cumulative sum of the sample values.}
\usage{
computeR0bar(x, numPerm = 100L, q1 = 0.025, q2 = 0.975)
}
\arguments{
\item{x}{a vector of sample values}

\item{numPerm}{the number of random permutations (or shuffles) of the sample value order}

\item{q1}{a real number for computing the lower confidence interval}

\item{q2}{a real number for computing the upper confidence interval}
}
\value{
a list \itemize{
\item mean the average difference of upper and lower records of the cumulative sum of \code{x}
\item q1 the q1 quantile of the difference
\item q1 the q2 quantile of the difference}
}
\description{
Computes the average difference between the number of upper and lower records of the cumulative sum of the sample values.
}
